#system(shQuote("MRD.exe" , type = "cmd" ))

#Function to install the required packages if haven't been installed
install.or.not <- function(mypkg){
	x<-is.element(mypkg, installed.packages()[,1]) 
	if(x==FALSE) {install.packages(mypkg)}
}

#Install required libraries
install.or.not("RGtk2")
install.or.not("tcltk")
install.or.not("gWidgets")
install.or.not("zoo")

install.or.not("cairoDevice")
install.or.not("grDevices")
install.or.not("graphics")
library(tcltk)
library(RGtk2)
library(gWidgets)
library(zoo)
library(cairoDevice)
library(grDevices)
library(graphics)
#Main window
main_window<-gtkWindow(show = TRUE)
main_window["title"] <- "Multisite Rainfall Downscaling"
main_window$setDefaultSize(600,600)#Menubar
menubar<-gtkMenuBar()
file_menu<-gtkMenu()
file_item<-gtkMenuItemNewWithMnemonic(label="File")
file_item$setSubmenu(file_menu)
menubar$append(file_item)
open_item<-gtkMenuItemNewWithMnemonic("Open Script")
gSignalConnect(open_item,"activate", function(item) {
	file.show(tk_choose.files(default="",caption = "Open script",
	multi = FALSE,filters = matrix(c("R files",".r"),1,2,byrow = TRUE)))
})					
file_menu$append(open_item)
quit_item<-gtkMenuItemNewWithMnemonic("Quit")
gSignalConnect(quit_item,"activate",function(item){main_window$destroy()})
file_menu$append(quit_item)
help_menu<-gtkMenu()
help_item<-gtkMenuItemNewWithMnemonic(label="Help")
help_item$setSubmenu(help_menu)
menubar$append(help_item)
userGuide_item<-gtkMenuItemNewWithMnemonic("User Guide")
#Open Help pdf (Help document not added)
help_menu$append(userGuide_item)
gSignalConnect(userGuide_item,"activate",function(item){
	shell.exec(file.path(getwd(), "MRD Help.pdf"))
})
vbox<-gtkVBox()
main_window$add(vbox)
vbox$packStart(menubar,FALSE,FALSE)
#Add notebook
notebook<-gtkNotebook()
notebook['tab-pos']<-"left"
#Input data page
inputDataTable<-gtkTable(rows=3,columns=3,homogeneous=FALSE)
openButton<-gtkButtonNewWithLabel(" Open ")
inputDataPlotButton<-gtkButton(" Plot ")
FileLabel<-gtkLabelNew("")
inputDataPlotSaveButton<-gtkButtonNewWithLabel(" Save Plot ")
gSignalConnect(openButton,"clicked",function(openButton,event,data){
	File<-tk_choose.files(default="",caption = "Select input data file",
	multi = FALSE,
	filters =matrix(c("Text",".txt","R data", ".data","Dat",".dat"),3,2,byrow = TRUE))
	FileLabel$setText(File)
})		
inputDataTable$attach(openButton,left.attach=0,1,top.attach=0,1,
	xoptions=c("shrink","fill"),yoptions="")
inputDataTable$attach(FileLabel,left.attach=1,2,top.attach=0,1,
	xoptions=c("expand","fill"),yoptions="")
inputDataTable$attach(inputDataPlotButton,left.attach=2,3,top.attach=0,1,
	xoptions=c("shrink","fill"),yoptions="")
inputDataTable$attach(inputDataPlotSaveButton,left.attach=2,3,top.attach=1,2,
	xoptions=c("shrink","fill"),yoptions="")
notebook$appendPage(inputDataTable,gtkLabel("Rainfall Data File"))
vbox$packStart(notebook,TRUE,TRUE)
#Add graphic device to input data page
inputDataPlotDevice<-gtkDrawingArea()
inputDataPlotDevice$setSizeRequest(600,600)
asCairoDevice(inputDataPlotDevice)
inputDataTable$attach(inputDataPlotDevice,left.attach=1,2,top.attach=2,3,
	xoptions=c("shrink","fill"),yoptions="")
#Input data plot function
inputDataPlotFunction<-function(fontsize){
	inputDataFile<-FileLabel$getText()
	inputData<-read.table(inputDataFile,skip=3)
	if (ncol(inputData)==4) {rainfall<-inputData[1:nrow(inputData),4]}
	if (ncol(inputData)>=5) {rainfall<-apply(inputData[1:nrow(inputData),4:ncol(inputData)],1,mean)}
	x.Date<-as.Date(ISOdate(inputData[1,1],inputData[1,2],inputData[1,3]))+0:(nrow(inputData)-1)  
	rainfall.z<-zoo(rainfall,x.Date)
	par(pty="s")
	plot(rainfall.z,xlab="Date",ylab="mm",
		main="Monthly observed rainfall amount",
		cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)	
}		
gSignalConnect(inputDataPlotButton,"clicked",function(inputDataPlotButton,event,data){
	if (length(dev.list()>1)) dev.off()
    #Add graphic device to input data page
	inputDataPlotDevice<-gtkDrawingArea()
	inputDataPlotDevice$setSizeRequest(600,600)
	asCairoDevice(inputDataPlotDevice)
	inputDataTable$attach(inputDataPlotDevice,left.attach=1,2,top.attach=2,3,
		xoptions=c("shrink","fill"),yoptions="")
	fontsize<-1.5
	inputDataPlotFunction(fontsize)
})
#Function to save plots
savePlotFileAs<-function(){plotFile<-tclvalue(tkgetSaveFile
	(initialfile="*.pdf",defaultextension = c(".pdf",".png",".bmp",".tif",
	".tiff",".jpg",".jpeg",".eps","emf"),filetypes=" {{Pdf files} {.pdf}}
	{{Png files} {.png}} {{Bmp files} {.bmp}} {{TIFF files} {.tif .tiff}}
	{{Jpeg files} {.jpg .jpeg}} {{Postscript files} {.eps}} {{Metafiles}
	{.emf}}"))
	return(plotFile)
}
#Function to save tables
saveGridFileAs<-function(){gridFile<-tclvalue(tkgetSaveFile(
	initialfile="*.txt",defaultextension = c(".txt",".dat",".out"),
	filetypes=" {{Text files} {.txt}} {{DAT files} {.dat}} {{OUT files}
	{.out}}"))
	return(gridFile)
}
getExt<-function(path)
	{
	 parts<-unlist(strsplit(path, "\\."))
     extention<-parts[length(parts)]
	 return(extention)
	}	
filenameExt<-function(path)
	{
	 parts<-unlist(strsplit(path, "\\/"))
     filename<-parts[length(parts)]
	 return(filename)
	}
#Save input data plot 
gSignalConnect(inputDataPlotSaveButton, "clicked", function(
	inputDataPlotSaveButton,event,data){
		plotFile<-savePlotFileAs()
		if (plotFile!=""){
			dev.new()
			fontsize<-1.5
			inputDataPlotFunction(fontsize)
			savePlot(filename=plotFile,type = getExt(plotFile),
				device = dev.cur(),restoreConsole = TRUE)
			dev.off()
		}
	}
)				
#Model parameter page 
modelParameterFrame<-gtkFrame("Model Parameters")
notebook$appendPage(modelParameterFrame,gtkLabel("Model Parameters"))
modelParameterTable<-gtkTable(rows=22,columns=4,homogeneous=FALSE)
modelParameterFrame$add(modelParameterTable)
previousLagFrame<-gtkFrame("number of previous lags for nLon")
previousLagTable<-gtkTable(rows=3,columns=10,homogeneous=FALSE)
previousLagFrame$add(previousLagTable)
# Modified on 26 May 2017	
seasonalityFrame<-gtkFrame("seasonal index (an integer between 1:12)")
seasonalityTable<-gtkTable(rows=3,columns=8,homogeneous=FALSE)
seasonalityFrame$add(seasonalityTable)

nYrLabel<-gtkLabel("number of years (ob.): ")
yrStartLabel<-gtkLabel("start year (ob.): ")
bandLabel<-gtkLabel("band: ")
gtkWidgetSetTooltipText(bandLabel,
	'The width of moving window equals to band*2+1.')
nStationLabel<-gtkLabel("number of stations: ")
nSimLabel<-gtkLabel("number of simulations: ")
nLonLabel<-gtkLabel("nLon: ")
gtkWidgetSetTooltipText(nLonLabel,'number of time periods for previous time lags (in days) for long term dependence')
lagLabel<-gtkLabel("lag: ")
nYrSimLabel<-gtkLabel("number of years (sim.): ")
yrStartSimLabel<-gtkLabel("start year (sim.): ")
localLabel<-gtkLabel("local: ")
gtkWidgetSetTooltipText(localLabel,'0 for no local wetness considered
1 for addition of a variable in the conditioning vector
2 for formation of subset from the data')
#genSpatialCheckButtonLabel<-gtkLabel("generate spatial dependence matrix ")
inclSpatialCheckButtonLabel<-gtkLabel("include spatial dependence matrix ")
# Add inclATM (modified on 19 May 2017)
inclATMCheckButtonLabel<-gtkLabel("use atmospheric variables in downscaling ")
rfOccOnlyCheckButtonLabel<-gtkLabel("simulate rainfall occurrence only ")
previousLagFromLabel<-gtkLabel("from: ")
previousLagToLabel<-gtkLabel("to: ")
# Modified on 26 May 2017	
seasonLabel1<-gtkLabel(" Jan: ")
seasonLabel2<-gtkLabel(" Feb: ")
seasonLabel3<-gtkLabel(" Mar: ")
seasonLabel4<-gtkLabel("   Apr: ")
seasonLabel5<-gtkLabel("   May: ")
seasonLabel6<-gtkLabel("   Jun: ")
seasonLabel7<-gtkLabel("   Jul: ")
seasonLabel8<-gtkLabel("   Aug: ")
seasonLabel9<-gtkLabel("   Sep: ")
seasonLabel10<-gtkLabel("   Oct: ")
seasonLabel11<-gtkLabel("   Nov: ")
seasonLabel12<-gtkLabel("   Dec: ")

estimateButton<-gtkButton("Estimate")
nYrSpin<-gtkSpinButtonNew()
yrStartSpin<-gtkSpinButtonNew()
bandSpin<-gtkSpinButtonNew()
nStationSpin<-gtkSpinButtonNew()
nYrSimSpin<-gtkSpinButtonNew()
nLonSpin<-gtkSpinButtonNew()
lagSpin<-gtkSpinButtonNew()
# Modified on 26 May 2017	
seasonSpin1<-gtkSpinButtonNew()
seasonSpin2<-gtkSpinButtonNew()
seasonSpin3<-gtkSpinButtonNew()  
seasonSpin4<-gtkSpinButtonNew() 
seasonSpin5<-gtkSpinButtonNew()
seasonSpin6<-gtkSpinButtonNew()
seasonSpin7<-gtkSpinButtonNew()  
seasonSpin8<-gtkSpinButtonNew() 
seasonSpin9<-gtkSpinButtonNew()
seasonSpin10<-gtkSpinButtonNew()
seasonSpin11<-gtkSpinButtonNew()  
seasonSpin12<-gtkSpinButtonNew() 
  
nSimSpin<-gtkSpinButtonNew()
yrStartSimSpin<-gtkSpinButtonNew()
localSpin<-gtkSpinButtonNew()
genSpatialCheckButton<-gtkCheckButton()
genSpatialCheckButton$setActive(TRUE)
inclSpatialCheckButton<-gtkCheckButton()
inclSpatialCheckButton$setActive(TRUE)
# Add inclATM (modified on 19 May 2017)
inclATMCheckButton<-gtkCheckButton()
inclATMCheckButton$setActive(TRUE)
rfOccOnlyCheckButton<-gtkCheckButton()
rfOccOnlyCheckButton$setActive(FALSE)
previousLagFromSpin<-list()
previousLagToSpin<-list()
#max(nLon)=3
for (i in 1:3)
	{
	 previousLagFromSpin[[i]]<-gtkSpinButtonNew()
	 previousLagToSpin[[i]]<-gtkSpinButtonNew() 
    }
	
#function to set spin button
spinSetFun<-function(spin,mini,maxi,initial,pg){	 	 
	gtkSpinButtonSetNumeric(spin,TRUE)
	gtkSpinButtonSetSnapToTicks(spin,TRUE)
	gtkSpinButtonSetWrap(spin,TRUE)
	gtkSpinButtonSetDigits(spin,0)
	gtkSpinButtonSetRange(spin,mini,maxi)
	#gtkSpinButtonSetIncrements(object, step, page)
	gtkSpinButtonSetIncrements(spin,1,pg)
	gtkSpinButtonSetValue(spin,initial)
}	

#Attach widgets to model parameters page
modelParameterTable$attach(nYrLabel,left.attach=0,1,top.attach=0,1,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(yrStartLabel,left.attach=0,1,top.attach=1,2,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nStationLabel,left.attach=0,1,top.attach=2,3,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(bandLabel,left.attach=0,1,top.attach=3,4,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(lagLabel,left.attach=0,1,top.attach=4,5,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(localLabel,left.attach=0,1,top.attach=5,6,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nLonLabel,left.attach=0,1,top.attach=6,7,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nYrSimLabel,left.attach=2,3,top.attach=0,1,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(yrStartSimLabel,left.attach=2,3,top.attach=1,2,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nSimLabel,left.attach=2,3,top.attach=2,3,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(rfOccOnlyCheckButtonLabel,left.attach=2,3,
	top.attach=3,4,xoptions=c("expand","fill"),yoptions="")
#modelParameterTable$attach(genSpatialCheckButtonLabel,left.attach=2,3,
#	top.attach=4,5,xoptions=c("expand","fill"),yoptions="")	
modelParameterTable$attach(inclSpatialCheckButtonLabel,left.attach=2,3,
	top.attach=4,5,xoptions=c("expand","fill"),yoptions="")
# Add inclATM (modified on 19 May 2017)
modelParameterTable$attach(inclATMCheckButtonLabel,left.attach=2,3,
                           top.attach=5,6,xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nYrSpin,left.attach=1,2,top.attach=0,1,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(yrStartSpin,left.attach=1,2,top.attach=1,2,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nStationSpin,left.attach=1,2,top.attach=2,3,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(bandSpin,left.attach=1,2,top.attach=3,4,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(lagSpin,left.attach=1,2,top.attach=4,5,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(localSpin,left.attach=1,2,top.attach=5,6,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nLonSpin,left.attach=1,2,top.attach=6,7,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nYrSimSpin,left.attach=3,4,top.attach=0,1,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(yrStartSimSpin,left.attach=3,4,top.attach=1,2,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(nSimSpin,left.attach=3,4,top.attach=2,3,
	xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(rfOccOnlyCheckButton,left.attach=3,4,
	top.attach=3,4,xoptions=c("expand","fill"),yoptions="")
#modelParameterTable$attach(genSpatialCheckButton,left.attach=3,4,
#	top.attach=4,5,xoptions=c("expand","fill"),yoptions="")
modelParameterTable$attach(inclSpatialCheckButton,left.attach=3,4,
	top.attach=4,5,xoptions=c("expand","fill"),yoptions="")
# Add inclATM (modified on 19 May 2017)
modelParameterTable$attach(inclATMCheckButton,left.attach=3,4,
  top.attach=5,6,xoptions=c("expand","fill"),yoptions="")
#previous time lags frame
modelParameterTable$attach(previousLagFrame,left.attach=0,4,
	top.attach=7,10,xoptions=c("expand","fill"),yoptions="")
previousLagTable$attach(previousLagFromLabel,left.attach=0,1,
	top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
previousLagTable$attach(previousLagToLabel,left.attach=0,1,
	top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
previousLagTable$attach(previousLagFromSpin[[1]],left.attach=1,2,
	top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
previousLagTable$attach(previousLagToSpin[[1]],left.attach=1,2,
	top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
# Modified on 26 May 2017	
modelParameterTable$attach(seasonalityFrame,left.attach=0,4,
                           top.attach=11,13,xoptions=c("expand","fill"),yoptions="")

seasonalityTable$attach(seasonLabel1,left.attach=0,1,
                        top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin1,left.attach=1,2,
                        top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonLabel2,left.attach=0,1,
                        top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin2,left.attach=1,2,
                        top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonLabel3,left.attach=0,1,
                        top.attach=2,3,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin3,left.attach=1,2,
                        top.attach=2,3,xoptions=c("shrink","fill"),yoptions="")

seasonalityTable$attach(seasonLabel4,left.attach=2,3,
                        top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin4,left.attach=3,4,
                        top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonLabel5,left.attach=2,3,
                        top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin5,left.attach=3,4,
                        top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonLabel6,left.attach=2,3,
                        top.attach=2,3,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin6,left.attach=3,4,
                        top.attach=2,3,xoptions=c("shrink","fill"),yoptions="")

seasonalityTable$attach(seasonLabel7,left.attach=4,5,
                        top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin7,left.attach=5,6,
                        top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonLabel8,left.attach=4,5,
                        top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin8,left.attach=5,6,
                        top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonLabel9,left.attach=4,5,
                        top.attach=2,3,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin9,left.attach=5,6,
                        top.attach=2,3,xoptions=c("shrink","fill"),yoptions="")

seasonalityTable$attach(seasonLabel10,left.attach=6,7,
                        top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin10,left.attach=7,8,
                        top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonLabel11,left.attach=6,7,
                        top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin11,left.attach=7,8,
                        top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonLabel12,left.attach=6,7,
                        top.attach=2,3,xoptions=c("shrink","fill"),yoptions="")
seasonalityTable$attach(seasonSpin12,left.attach=7,8,
                        top.attach=2,3,xoptions=c("shrink","fill"),yoptions="")
#create dummy progress bar
progressBar<-gtkProgressBar()
progressBar$setText("Multisite Rainfall Downscaling")

para_file="data.dat"
#Use the parameter in the file 'data.dat' as the initial value of the RGUI
#if the file exists
if (file.exists(para_file)){
	parameters<-read.table(para_file, header =FALSE, sep = "\t", nrows =1,skip = 2,strip.white = FALSE)
	prev_lags<-read.table(para_file, header =FALSE, sep = "\t", nrows =2,skip = 4,strip.white = FALSE)
	# Modified on 26 May 2017
	seasonIdx<-read.table(para_file, header =FALSE, sep = "\t", nrows =1,skip = 8,strip.white = FALSE)
	  
	rf_input_file<-read.table(para_file, header =FALSE, sep = "\t", nrows =1,skip = 10,strip.white = FALSE)
	rf_output_file<-read.table(para_file, header =FALSE, sep = "\t", nrows =1,skip = 12,strip.white = FALSE)
	corr_occ_file<-read.table(para_file, header =FALSE, sep = "\t", nrows =1,skip = 13,strip.white = FALSE)
	corr_amt_file<-read.table(para_file, header =FALSE, sep = "\t", nrows =1,skip = 16,strip.white = FALSE)
	dist_file<-read.table(para_file, header =FALSE, sep = "\t", nrows =1,skip = 18,strip.white = FALSE)
	
	nYr<-as.numeric(parameters[1])
	yrStart<-as.numeric(parameters[2])
	band<-as.numeric(parameters[3])
	nStation<-as.numeric(parameters[4])	  
	nSim<-as.numeric(parameters[5])
	nLon<-as.numeric(parameters[6])
	lag<-as.numeric(parameters[7])
	nYrSim<-as.numeric(parameters[8])
	yrStartSim<-as.numeric(parameters[9])
	amt<-as.numeric(parameters[10])
	local<-as.numeric(parameters[11])
	genSpatial<-as.numeric(parameters[12])
	inclSpatial<-as.numeric(parameters[13])
	# Add inclATM (modified on 19 May 2017)
	inclATM<-as.numeric(parameters[14])
  
	# Modified on 26 May 2017
	seasonIdx1<-as.numeric(seasonIdx[1])
	seasonIdx2<-as.numeric(seasonIdx[2])
	seasonIdx3<-as.numeric(seasonIdx[3])
	seasonIdx4<-as.numeric(seasonIdx[4])
	seasonIdx5<-as.numeric(seasonIdx[5])
	seasonIdx6<-as.numeric(seasonIdx[6])
	seasonIdx7<-as.numeric(seasonIdx[7])
	seasonIdx8<-as.numeric(seasonIdx[8])
	seasonIdx9<-as.numeric(seasonIdx[9])
	seasonIdx10<-as.numeric(seasonIdx[10])
	seasonIdx11<-as.numeric(seasonIdx[11])
	seasonIdx12<-as.numeric(seasonIdx[12])
	
	
	spinSetFun(spin=nYrSpin,mini=1,maxi=100,initial=nYr,pg=5)
	spinSetFun(spin=yrStartSpin,mini=1,maxi=2100,initial=yrStart,pg=5)
	spinSetFun(spin=nStationSpin,mini=1,maxi=45,initial=nStation,pg=5)
	spinSetFun(spin=bandSpin,mini=1,maxi=15,initial=band,pg=5)
	spinSetFun(spin=lagSpin,mini=0,maxi=1,initial=lag,pg=1)
	spinSetFun(spin=nLonSpin,mini=1,maxi=3,initial=nLon,pg=1)#max(nLon)=3
	spinSetFun(spin=nYrSimSpin,mini=1,maxi=100,initial=nYrSim,pg=5) #nYrSim < nYr
	spinSetFun(spin=yrStartSimSpin,mini=1,maxi=2100,initial=yrStartSim,pg=5)
	spinSetFun(spin=nSimSpin,mini=1,maxi=100,initial=nSim,pg=10)
	spinSetFun(spin=localSpin,mini=0,maxi=2,initial=local,pg=1)	
	
	spinSetFun(spin=previousLagFromSpin[[1]],mini=0,maxi=900,initial=prev_lags[1,1],pg=1)	
	spinSetFun(spin=previousLagToSpin[[1]],mini=0,maxi=900,initial=prev_lags[2,1],pg=1)	
	# Modified on 26 May 2017
	spinSetFun(spin=seasonSpin1,mini=1,maxi=12,initial=1,pg=1)
	spinSetFun(spin=seasonSpin2,mini=1,maxi=12,initial=1,pg=1)
	spinSetFun(spin=seasonSpin3,mini=1,maxi=12,initial=1,pg=1)
	spinSetFun(spin=seasonSpin4,mini=1,maxi=12,initial=2,pg=1)
	spinSetFun(spin=seasonSpin5,mini=1,maxi=12,initial=2,pg=1)
	spinSetFun(spin=seasonSpin6,mini=1,maxi=12,initial=2,pg=1)
	spinSetFun(spin=seasonSpin7,mini=1,maxi=12,initial=3,pg=1)
	spinSetFun(spin=seasonSpin8,mini=1,maxi=12,initial=3,pg=1)
	spinSetFun(spin=seasonSpin9,mini=1,maxi=12,initial=3,pg=1)
	spinSetFun(spin=seasonSpin10,mini=1,maxi=12,initial=4,pg=1)
	spinSetFun(spin=seasonSpin11,mini=1,maxi=12,initial=4,pg=1)
	spinSetFun(spin=seasonSpin12,mini=1,maxi=12,initial=4,pg=1)
	
	
	#Add additional spinbutton according to the number of pre_lags
	if (nLon==2){
		previousLagTable$attach(previousLagFromSpin[[2]],left.attach=2,3,
			top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
		previousLagTable$attach(previousLagToSpin[[2]],left.attach=2,3,
			top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
		spinSetFun(spin=previousLagFromSpin[[2]],mini=0,maxi=900,initial=prev_lags[1,2],pg=1)	
		spinSetFun(spin=previousLagToSpin[[2]],mini=0,maxi=900,initial=prev_lags[2,2],pg=1)	
	
	}
	else if (nLon==3){
		previousLagTable$attach(previousLagFromSpin[[2]],left.attach=2,3,
			top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
		previousLagTable$attach(previousLagToSpin[[2]],left.attach=2,3,
			top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
		previousLagTable$attach(previousLagFromSpin[[3]],left.attach=3,4,
			top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
		previousLagTable$attach(previousLagToSpin[[3]],left.attach=3,4,
			top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")	
		spinSetFun(spin=previousLagFromSpin[[2]],mini=0,maxi=900,initial=prev_lags[1,2],pg=1)	
		spinSetFun(spin=previousLagToSpin[[2]],mini=0,maxi=900,initial=prev_lags[2,2],pg=1)
		spinSetFun(spin=previousLagFromSpin[[3]],mini=0,maxi=900,initial=prev_lags[1,3],pg=1)	
		spinSetFun(spin=previousLagToSpin[[3]],mini=0,maxi=900,initial=prev_lags[2,3],pg=1)	
	}
} else {
#If the file 'data.dat' does not exist, then create it

	spinSetFun(spin=nYrSpin,mini=1,maxi=100,initial=15,pg=5)
	spinSetFun(spin=yrStartSpin,mini=1,maxi=2200,initial=1979,pg=5)
	spinSetFun(spin=nStationSpin,mini=1,maxi=45,initial=10,pg=5)
	spinSetFun(spin=bandSpin,mini=1,maxi=15,initial=15,pg=5)
	spinSetFun(spin=lagSpin,mini=0,maxi=1,initial=1,pg=1)
	spinSetFun(spin=nLonSpin,mini=1,maxi=3,initial=1,pg=1)#max(nLon)=3
	spinSetFun(spin=nYrSimSpin,mini=1,maxi=100,initial=15,pg=5) #nYrSim < nYr
	spinSetFun(spin=yrStartSimSpin,mini=1,maxi=2200,initial=1979,pg=5)
	spinSetFun(spin=nSimSpin,mini=1,maxi=150,initial=10,pg=10)
	spinSetFun(spin=localSpin,mini=0,maxi=2,initial=2,pg=1)
	spinSetFun(spin=previousLagFromSpin[[1]],mini=0,maxi=900,initial=2,pg=1)	
	spinSetFun(spin=previousLagToSpin[[1]],mini=0,maxi=900,initial=180,pg=1)
}
gSignalConnect(nLonSpin,"changed",function(nLonSpin,event,data){
		lapply(previousLagFromSpin, function(x) previousLagTable$remove(x))
		lapply(previousLagToSpin, function(x) previousLagTable$remove(x)) 	
		previousLagTable$attach(previousLagFromLabel,left.attach=0,1,
			top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
		previousLagTable$attach(previousLagToLabel,left.attach=0,1,
			top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
		nLon<-grab_int_value(nLonSpin)	   
		for (i in 1:nLon){
			spinSetFun(spin=previousLagFromSpin[[i]],mini=0,maxi=900,initial=prev_lags[1,i],pg=1)	
			spinSetFun(spin=previousLagToSpin[[i]],mini=0,maxi=900,initial=prev_lags[2,i],pg=1)
		
			previousLagTable$attach(previousLagFromSpin[[i]],
				left.attach=i,i+1,top.attach=0,1,xoptions=c("shrink","fill"),
				yoptions="")
			previousLagTable$attach(previousLagToSpin[[i]],left.attach=i,i+1,
				top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")	 
		}		 					
	})				
	

gSignalConnect(nLonSpin,"changed",function(nLonSpin,event,data){
    lapply(previousLagFromSpin, function(x) previousLagTable$remove(x))
	lapply(previousLagToSpin, function(x) previousLagTable$remove(x)) 	
	previousLagTable$attach(previousLagFromLabel,left.attach=0,1,
		top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")
	previousLagTable$attach(previousLagToLabel,left.attach=0,1,
		top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")
	nLon<-grab_int_value(nLonSpin)	   
	for (i in 1:nLon){
		previousLagTable$attach(previousLagFromSpin[[i]],
			left.attach=i,i+1,top.attach=0,1,xoptions=c("shrink","fill"),
			yoptions="")
		previousLagTable$attach(previousLagToSpin[[i]],left.attach=i,i+1,
			top.attach=1,2,xoptions=c("shrink","fill"),yoptions="")	     
	}		 					
})

# Modified on 26 May 2017	
modelParameterTable$attach(estimateButton,left.attach=1,2,
	top.attach=14,15,xoptions=c("expand","fill"),yoptions="",xpadding=0,
	ypadding=10)
# Modified on 26 May 2017	
modelParameterTable$attach(progressBar,left.attach=0,4,top.attach=17,18,
	xoptions=c("expand","fill"),yoptions="",xpadding=5, ypadding=10)
notRespondingLabel<-gtkLabelNew("")
##Function to retrieve the spinbutton value
grab_int_value<-function(a_spinner,user_data){
   return(a_spinner$getValueAsInt())
}
errMesgFun<-function(errMessage){
	errWindow<-gtkWindow(show=FALSE)
	errWindow$setDefaultSize(500,50)
	errWindow["title"] <- "Error Message"
	errLabel<-gtkLabel(errMessage)		 
	errLabel$setLineWrap(TRUE)
	errLabel$setWidthChars(100)
	errWindow$add(errLabel)
	errWindow$show()
}
#Function to plot replicates
replPlotFun<-function(nSim,nStation,yrStartSim,nYrSim,amt,replOptionSel,fontsize){
	for (sim.index in 1:nSim){
		if(length(replOptionSel$getSelectedRows()$retval)==1){
			if (replOptionSel$getSelectedRows()$retval[[1]]$getIndices()==(sim.index-1)){
				nLine<-ISOdate(yrStartSim+nYrSim,1,1)-ISOdate(yrStartSim,1,1)
				replRf<-read.table(file="rf_amt.out",header=FALSE,skip=(sim.index-1)*(nLine+1),nrows=nLine)
				if (nStation==1) {replRfMeanOfAllStns<-replRf[1:nrow(replRf),4]}
				if (nStation>=2) {replRfMeanOfAllStns<-apply(replRf[1:nrow(replRf),4:ncol(replRf)],1,mean)}
				x.Date<-as.Date(ISOdate(replRf[1,1],replRf[1,2],replRf[1,3]))+0:(nrow(replRf)-1)
				if (amt==1){
				replRfMeanOfAllStns.z<-zoo(replRfMeanOfAllStns,x.Date)							
				par(pty="s")
				plot(replRfMeanOfAllStns.z,xlab="Date",ylab="mm",main=paste("Monthly rainfall amount (sim.",sim.index,")"),
					cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)	
				}
				#else{
				#	par(pty="s")
				#	plot(x.Date,replRfMeanOfAllStns,pch=20,col="red",xlab="Date",ylab="",
				#		main=paste("Monthly rainfall occurrence (sim.",sim.index," )"),
				#		cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)	
				#}
			}
		}
	}
}
#Function to retrieve user defined parameters from Model Parameters Page and overwrite the file "data.dat"
#Then produce plots for replicates and also enable to save the plots
# Add inclATM (modified on 19 May 2017)
replFun<-function(nYr,yrStart,band,nStation,nSim,nLon,lag,nYrSim,yrStartSim,amt,local,genSpatial,inclSpatial,inclATM,inputDataFile,distFile,
                  seasonIdx1,seasonIdx2.seasonIdx3,seasonIdx4,seasonIdx5,seasonIdx6,seasonIdx7,seasonIdx8,seasonIdx9,seasonIdx10,seasonIdx11,seasonIdx12){			
	outputDataFile<-"rf_amt.out"
	parameters<-file("data.dat")
	writeLines(c("Data file to supply values of input parameters & names of data files",
			"NO	Yst(O)	BAND	NSTN	NSIM	NLON	LAG	NG	YST(G)	AMT	LOCAL	SPATIAL	CROSS	NATM"), parameters)
	cat(nYr,yrStart,band,nStation,nSim,nLon,lag,nYrSim,yrStartSim,amt,local,genSpatial,inclSpatial,inclATM,"\n",sep="\t",file="data.dat",append=TRUE)
	cat("Number of previous time lags (in days) for nLon","\n",file="data.dat",append=TRUE)	  
	previousLagFrom<-list()
	previousLagTo<-list()
	if (nLon==1){
		previousLagFrom[[1]]<-grab_int_value(previousLagFromSpin[[1]])
		cat(previousLagFrom[[1]],"\n",file="data.dat",append=TRUE)
		previousLagTo[[1]]<-grab_int_value(previousLagToSpin[[1]])
		cat(previousLagTo[[1]],"\n",file="data.dat",append=TRUE)
	}
	if (nLon==2){
		previousLagFrom[[1]]<-grab_int_value(previousLagFromSpin[[1]])
		previousLagFrom[[2]]<-grab_int_value(previousLagFromSpin[[2]])
		cat(previousLagFrom[[1]],previousLagFrom[[2]],sep="\t",file="data.dat",append=TRUE)
		cat("\n",file="data.dat",append=TRUE)
		previousLagTo[[1]]<-grab_int_value(previousLagToSpin[[1]])
		previousLagTo[[2]]<-grab_int_value(previousLagToSpin[[2]])
		cat(previousLagTo[[1]],previousLagTo[[2]],sep="\t",file="data.dat",append=TRUE)
		cat("\n",file="data.dat",append=TRUE)
	}
	if (nLon==3){
		previousLagFrom[[1]]<-grab_int_value(previousLagFromSpin[[1]])
		previousLagFrom[[2]]<-grab_int_value(previousLagFromSpin[[2]])
		previousLagFrom[[3]]<-grab_int_value(previousLagFromSpin[[3]])
		cat(previousLagFrom[[1]],previousLagFrom[[2]],previousLagFrom[[3]],sep="\t",file="data.dat",append=TRUE)
		cat("\n",file="data.dat",append=TRUE)
		previousLagTo[[1]]<-grab_int_value(previousLagToSpin[[1]])
		previousLagTo[[2]]<-grab_int_value(previousLagToSpin[[2]])
		previousLagTo[[3]]<-grab_int_value(previousLagToSpin[[3]])
		cat(previousLagTo[[1]],previousLagTo[[2]],previousLagTo[[3]],sep="\t",file="data.dat",append=TRUE)
		cat("\n",file="data.dat",append=TRUE)
	}
	 
	cat("Season index for each month (from January to December)","\n",file="data.dat",append=TRUE)	  
	cat("JAN	FEB	MAR	APR	MAY	JUN	JUL	AUG	SEP	OCT	NOV	DEC","\n",file="data.dat",append=TRUE)	  
	cat(seasonIdx1,seasonIdx2,seasonIdx3,seasonIdx4,seasonIdx5,seasonIdx6,seasonIdx7,seasonIdx8,seasonIdx9,seasonIdx10,seasonIdx11,seasonIdx12,"\n",sep="\t",file="data.dat",append=TRUE)
	
	cat("Name of rainfall data file","\n",file="data.dat",append=TRUE)
	cat(inputDataFile,"\n",file="data.dat",append=TRUE)
	cat("Name of output data file","\n",file="data.dat",append=TRUE)
	cat(outputDataFile,"\n",file="data.dat",append=TRUE)
	cat("Name of random number correlation file for occurrences","\n",file="data.dat",append=TRUE)
	cat("cor_occr.dat","\n",file="data.dat",append=TRUE)
	cat("Name of random number correlation file for amount","\n",file="data.dat",append=TRUE)
	cat("cor_amt.dat","\n",file="data.dat",append=TRUE)
	cat("Name of distance file","\n",file="data.dat",append=TRUE)
	cat(distFile,"\n",file="data.dat",append=TRUE)
	# modified on 19 May 2017
	cat("Name of file containing details of total number of atmospheric variables and current (calibration) and future (application) climates data file for each station",
	    "\n",file="data.dat",append=TRUE)
	cat("pred_all.dat","\n",file="data.dat",append=TRUE)
	cat("Name of file containing details of atmospheric variables for each station and season : FOR RAINFALL OCCURRENCES",
	    "\n",file="data.dat",append=TRUE)
	cat("pred_occr.dat","\n",file="data.dat",append=TRUE)
	cat("Name of file containing details of atmospheric variables for each station and season : FOR RAINFALL AMOUNTS",
	    "\n",file="data.dat",append=TRUE)
	cat("pred_amt.dat","\n",file="data.dat",append=TRUE)
	close(parameters)
	progressBar$setFraction(1/100)
	Sys.sleep(0.1 )
	info <- sprintf("%d%% completed",1)
	progressBar$setText(sprintf("Estimate Multisite Rainfall (%s)",info))
	  
	i=2			 
	progressBar$setFraction(2/100)
	Sys.sleep(0.1 )
	info <- sprintf("%d%% completed",2)
	progressBar$setText(sprintf("Estimate Multisite Rainfall (%s)",info))
						  	
	i=3			 	 
	progressBar$setFraction(15/100)
	Sys.sleep(0.1 )
	info <- sprintf("%d%% completed",15)
	progressBar$setText(sprintf("Estimate Multisite Rainfall (%s)",info))
					  
	i=4			 
	modelParameterTable$attach(notRespondingLabel,left.attach=0,4,top.attach=20,21,
		xoptions=c("expand","fill"),yoptions="",xpadding = 5, ypadding = 10)
	notRespondingLabel$setMarkup(paste('<span foreground="red" gravity="west" size="xx-large">','Program is running ...','</span>',sep=""))
	progressBar$setFraction(20/100)
	Sys.sleep(0.1 )
	info <- sprintf("%d%% completed",20)
	progressBar$setText(sprintf("Estimate Multisite Rainfall (%s)",info))
						  
	i=5
	system(shQuote("MRD.exe" , type = "cmd" ))
	progressBar$setFraction(60/100)
	Sys.sleep(0.1 )
	info <- sprintf("%d%% completed", 60)
	progressBar$setText(sprintf("Estimate Multisite Rainfall (%s)",info))
	
	i=6
	#Read user-defined parameters
	parameters<-scan(file="data.dat",skip=2,nline=1,quiet = TRUE)
	nYr<-parameters[1]
	yrStart<-parameters[2]
	band<-parameters[3]
	nStation<-parameters[4]	  
	nSim<-parameters[5]
	nLon<-parameters[6]
	lag<-parameters[7]
	nYrSim<-parameters[8]
	yrStartSim<-parameters[9]
	amt<-parameters[10]
	local<-parameters[11]
	genSpatial<-parameters[12]
	inclSpatial<-parameters[13]
	inclATM<-parameters[14]
	
	# Modified on 26 May 2017
	seasonIdx<-read.table("data.dat", header =FALSE, sep = "\t", nrows =1,skip = 8,strip.white = FALSE)
	seasonIdx1<-as.numeric(seasonIdx[1])
	seasonIdx2<-as.numeric(seasonIdx[2])
	seasonIdx3<-as.numeric(seasonIdx[3])
	seasonIdx4<-as.numeric(seasonIdx[4])
	seasonIdx5<-as.numeric(seasonIdx[5])
	seasonIdx6<-as.numeric(seasonIdx[6])
	seasonIdx7<-as.numeric(seasonIdx[7])
	seasonIdx8<-as.numeric(seasonIdx[8])
	seasonIdx9<-as.numeric(seasonIdx[9])
	seasonIdx10<-as.numeric(seasonIdx[10])
	seasonIdx11<-as.numeric(seasonIdx[11])
	seasonIdx12<-as.numeric(seasonIdx[12])
	
	#set simulation options
	child_simulationOptionFrame<-simulationOptionFrame[[1]]
	simulationOptionFrame$remove(child_simulationOptionFrame)
	replScrolledWindow <- gtkScrolledWindow()
	replScrolledWindow$setSizeRequest(200,600)
	
	simulationList <- data.frame(sim.index=1:nSim,sim.name=paste("sim.",1:nSim,sep=""))	
	replModel<-rGtkDataFrame(simulationList)
	replView<-gtkTreeView(replModel)
	replView$getSelection()$setMode("browse")
	replColumn<-gtkTreeViewColumn("simulation      ",gtkCellRendererText(),text=1)
	replView$appendColumn(replColumn)  
	replScrolledWindow$add(replView)	  	
	simulationOptionFrame$add(replScrolledWindow)
	
	replOptionSel<-replView$getSelection()
	gSignalConnect(replOptionSel,"changed",function(replOptionSel,event,data){
		if (length(dev.list()>1)) dev.off()	
		#Add graphic device to view simulation page			 
		replPlotDevice<-gtkDrawingArea()
		replPlotDevice$setSizeRequest(600,600)
		asCairoDevice(replPlotDevice)
		viewsimulationsTable$attach(replPlotDevice,left.attach=1,2,top.attach=0,1,
			xoptions=c("expand","fill"),yoptions="",ypadding=0)
		Sys.sleep(.1)	
		fontsize<-1.5
		replPlotFun(nSim,nStation,yrStartSim,nYrSim,amt,replOptionSel,fontsize)
	})
	#save simulation
	gSignalConnect(saveReplButton, "clicked", function(saveReplButton,event,data){
		ReplPlot<-savePlotFileAs()
		if (ReplPlot!=""){
			dev.new()
			fontsize<-1.6
			replPlotFun(nSim,nStation,yrStartSim,nYrSim,amt,replOptionSel,fontsize)
			savePlot(filename=ReplPlot,type = getExt(ReplPlot),device = dev.cur(),restoreConsole = TRUE)
			dev.off()
		}
	})
}
			
estimateFun<-function(){
	i=0
	progressBar$setFraction(0/100)
	Sys.sleep(0.1 )
	info <- sprintf("%d%% completed",0)
	progressBar$setText(sprintf("Estimate Multisite Rainfall (%s)",info))
	parameters<-scan(file="data.dat",skip=2,nline=1,quiet = TRUE)
    nStationPre<-parameters[4]#previous value of nStation	  				 
	i=1
	nYr<-grab_int_value(nYrSpin)
	yrStart<-grab_int_value(yrStartSpin)
	band<-grab_int_value(bandSpin)
	nStation<-grab_int_value(nStationSpin)
	nSim<-grab_int_value(nSimSpin)
	nYrSim<-grab_int_value(nYrSimSpin)
	yrStartSim<-grab_int_value(yrStartSimSpin)
	lag<-grab_int_value(lagSpin)
	nLon<-grab_int_value(nLonSpin)
	ifelse(rfOccOnlyCheckButton$getActive()==TRUE,amt<-0,amt<-1)
	local<-grab_int_value(localSpin)
	nLon<-grab_int_value(nLonSpin)
	#nStation<-45, 11346;#nStation<-44, 10980 
	
	# Modified on 26 May 2017
	seasonIdx1<-grab_int_value(seasonSpin1)
	seasonIdx2<-grab_int_value(seasonSpin2)
	seasonIdx3<-grab_int_value(seasonSpin3)
	seasonIdx4<-grab_int_value(seasonSpin4)
	seasonIdx5<-grab_int_value(seasonSpin5)
	seasonIdx6<-grab_int_value(seasonSpin6)
	seasonIdx7<-grab_int_value(seasonSpin7)
	seasonIdx8<-grab_int_value(seasonSpin8)
	seasonIdx9<-grab_int_value(seasonSpin9)
	seasonIdx10<-grab_int_value(seasonSpin10)
	seasonIdx11<-grab_int_value(seasonSpin11)
	seasonIdx12<-grab_int_value(seasonSpin12)
	
	nlineCorPre<-length(count.fields("cor_occr.dat")) 
	nlineCor<-366*(nStation+1)  
	ifelse(inclSpatialCheckButton$getActive()==TRUE,inclSpatial<-1,inclSpatial<-0)
	# Add inclATM (modified on 19 May 2017)
	ifelse(inclATMCheckButton$getActive()==TRUE,inclATM<-1,inclATM<-0)
	
	ifelse(nlineCor==nlineCorPre,genSpatial<-0,genSpatial<-1)
	#if(genSpatialCheckButton$getActive()==TRUE) {genSpatial<-1}
	inputDataFile<-FileLabel$getText()
	#parameter validation test
	#Input data file is not selected
	if (inputDataFile==""){	
		 errMessage<-"The input data file was not selected. "
		 errMesgFun(errMessage)
	}
	#Input data file is selected, but is not "rain.dat" file
	#In this case, the user needs to select a distance file if nStation > 1
	else if(filenameExt(inputDataFile)!= "rain.dat" & nStation>1){
		distFile<-tk_choose.files(default="",caption = paste("Select distance file"),
        multi = FALSE, filters =matrix(c("Text",".txt","R data", ".data","Dat",".dat"),3, 2, byrow = TRUE)) 
		if(distFile==""){
			errMessage<-"Distance file was not selected. "
			errMesgFun(errMessage)
		}
		else{
			genSpatial<-1		
			#Function to retrieve user defined parameters from Model Parameters Page and write into a file "data.dat"
			#Then produce plots for replicates and also enable to save the plots
			replFun(nYr,yrStart,band,nStation,nSim,nLon,lag,nYrSim,yrStartSim,amt,local,genSpatial,inclSpatial,inclATM,inputDataFile,distFile,
			        seasonIdx1,seasonIdx2.seasonIdx3,seasonIdx4,seasonIdx5,seasonIdx6,seasonIdx7,seasonIdx8,seasonIdx9,seasonIdx10,seasonIdx11,seasonIdx12)
			
			if (nStation==1){stnNumber<-read.table(inputDataFile,nrows=1)[2]}
			if (nStation>=2){stnNumber<-read.table(inputDataFile,nrows=1)[2:(nStation+1)]}
			#max(nStation)=45
			for (i in 0:45){
				rfAmtStnCombo$removeText(0)
			}
			if (nStation==1) {rfAmtStnCombo$appendText(stnNumber)}
			if (nStation>=2) {sapply(c("All stations",stnNumber),rfAmtStnCombo$appendText)}
			rfAmtStnCombo$setActive(0)
			for (i in 0:45){
				rfOccStnCombo$removeText(0)
			}		
			if (nStation==1) {rfOccStnCombo$appendText(stnNumber)}
			if (nStation>=2) {sapply(c("All stations",stnNumber),rfOccStnCombo$appendText)}
			rfOccStnCombo$setActive(0)
			progressBar$setFraction(100/100)
			Sys.sleep(0.1 )
			info <- sprintf("%d%% completed", 100)
			progressBar$setText(sprintf("Estimate Multisite Rainfall (%s)",info))
		}
	}
	#input file is "rain.dat"
	else{		 
		inputData<-read.table(inputDataFile,skip=3)
		yrStartMin<-inputData[1,1]
		yrStartMax<-inputData[nrow(inputData)-1,1]
		nStationMax<-ncol(inputData)-3			  
		if (yrStart<yrStartMin | yrStart>yrStartMax){	
			errMessage<-"'Start year (ob.)' exceeds the time period of the input data file. "
			errMesgFun(errMessage)
		}
		else if (yrStartSim<yrStart){
			errMessage<-"'Start year (sim.)' is earlier than 'start year (ob.)'. "
			errMesgFun(errMessage)
		}
		else if ((nYr+yrStart-1)>yrStartMax){
			errMessage<-"The sum of 'start year (ob.)' and 'number of years (ob.)' exceeds the time period of the input data file. "
			errMesgFun(errMessage)
		}		
		else if (nStation>nStationMax){
			errMessage<-"'Number of stations' exceeds the number of stations in the input data file. "
			errMesgFun(errMessage)
		}
		else if (nStation>nStationMax){
			errMessage<-"'Number of stations' exceeds the number of stations in the input data file. "
			errMesgFun(errMessage)
		}	
		#input file is "rain.dat" and nStation<=45		
		else{			
			distFile<-"dist.dat"
			#Function to retrieve user defined parameters from Model Parameters Page and write into a file "data.dat"
			#Then produce plots for replicates and also enable to save the plots
			replFun(nYr,yrStart,band,nStation,nSim,nLon,lag,nYrSim,yrStartSim,amt,local,genSpatial,inclSpatial,inclATM,inputDataFile,distFile,
			        seasonIdx1,seasonIdx2.seasonIdx3,seasonIdx4,seasonIdx5,seasonIdx6,seasonIdx7,seasonIdx8,seasonIdx9,seasonIdx10,seasonIdx11,seasonIdx12)
		}
		if (nStation==1){stnNumber<-read.table(inputDataFile,nrows=1)[2]}
		if (nStation>=2){stnNumber<-read.table(inputDataFile,nrows=1)[2:(nStation+1)]}
		#max(nStation)=45
		for (i in 0:45){
			rfAmtStnCombo$removeText(0)
		}
		if (nStation==1) {rfAmtStnCombo$appendText(stnNumber)}
		if (nStation>=2) {sapply(c("All stations",stnNumber),rfAmtStnCombo$appendText)}
		rfAmtStnCombo$setActive(0)
		for (i in 0:45){
			rfOccStnCombo$removeText(0)
		}		
		if (nStation==1){rfOccStnCombo$appendText(stnNumber)}
		if (nStation>=2) {sapply(c("All stations",stnNumber),rfOccStnCombo$appendText)}
		rfOccStnCombo$setActive(0)
		progressBar$setFraction(100/100)
		Sys.sleep(0.1 )
		info <- sprintf("%d%% completed", 100)
		progressBar$setText(sprintf("Estimate Multisite Rainfall (%s)",info))
	}
	modelParameterTable$remove(notRespondingLabel)
}
									
gSignalConnect(estimateButton,"clicked",function(estimateButton,event,data){
	list<-readLines("statistics_view_option.dat")
	list<-sub(list[2],"0",list)
	writeLines(list,"statistics_view_option.dat") 
	estimateFun()
	list<-readLines("statistics_view_option.dat")
	list<-sub(list[2],"1",list)
	writeLines(list,"statistics_view_option.dat") 
})				
#View simulations page
viewsimulationsTable<-gtkTable(rows=2,columns=2,homogeneous=FALSE)
notebook$appendPage(viewsimulationsTable,gtkLabel("View Simulations"))
simulationOptionFrame<-gtkFrame("Simulation Option")
viewsimulationsTable$attach(simulationOptionFrame,left.attach=0,1,
	top.attach=0,1,xoptions=c("shrink","fill"),yoptions="",ypadding=0)
saveReplButton<-gtkButtonNewWithLabel("Save Simulation")
viewsimulationsTable$attach(saveReplButton,left.attach=0,1,top.attach=1,2,
	xoptions=c("shrink","fill"),yoptions="",ypadding=0)
replScrolledWindow <- gtkScrolledWindow()
replScrolledWindow$setSizeRequest(200,600)
simulationOptionFrame$add(replScrolledWindow)		
#Statistics page
statisticOptionTable<-gtkTable(rows=1,columns=1,homogeneous=FALSE)
notebook$appendPage(statisticOptionTable,gtkLabel("Statistics"))
statVbox<-gtkVBox()
statisticOptionTable$attach(statVbox,left.attach=0,1,top.attach=0,1,
	xoptions=c("expand","fill"),yoptions=c("expand","fill"),ypadding=0)
notebookStat<-gtkNotebook()
notebookStat['tab-pos']<-"top"
statVbox$packStart(notebookStat,TRUE,TRUE)
rfAmtTable<-gtkTable(rows=3,columns=2,homogeneous=FALSE)

#Plot the statistics of the variables having the same format as the Mean of Annual Rainfall Amount
#annualStat=rfAmtAnnualSeasonalMean; main="Mean of Annual Rainfall Amount"
annualStatPlotFun<-function(annualStat,main,nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength){					 
	if (rfStatSelStn=="All stations"){
		if (nStation>=2){
			ColIndex<-seq(from=6,to=1+nStation*5,by=5)
			Rep<-apply(annualStat[2:(nSim+1),ColIndex],2,mean)
		}
		Ob<-annualStat[1,ColIndex]
		qq<-qqplot(Ob,Rep, plot.it = FALSE)		
		par(pty="s")
		plot(qq$x,qq$y,xlim=1.05*range(qq$x,qq$y),ylim=1.05*range(qq$x,qq$y),
		xlab = "Observed",ylab = "Simulated",main=paste(main),lwd=linewidth,
		cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,
		cex=fontsize,asp=1)
		#fit <- lm(Rep ~ Ob, data = qq)
		#abline(fit,lty=3,cex=1.2)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)				
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		annualStatSelStn<-annualStat[,1+selStn*5]
		ymax<-max(annualStatSelStn)
		ymin<-min(annualStatSelStn)
		yext<-(ymax-ymin)*0.05		
		par(mar=c(5.5,4.5,3,4),xpd=TRUE,pty="s")
		if (mainLength>45){
			boxplot(annualStatSelStn[2:(nSim+1)],ylim=c(ymin-yext,ymax+yext),xaxt='n',
				main=paste(main,"\nat station",rfStatSelStn),lwd=linewidth,
				xlab="",ylab="Statistic Value",cex.main=fontsize,cex.lab=fontsize,
				cex.axis=fontsize,cex=fontsize)
		}
		else {
			boxplot(annualStatSelStn[2:(nSim+1)],ylim=c(ymin-yext,ymax+yext),xaxt='n',
				main=paste(main,"at station",rfStatSelStn),lwd=linewidth,
				xlab="",ylab="Statistic Value",cex.main=fontsize,cex.lab=fontsize,
				cex.axis=fontsize,cex=fontsize)
		}
		points(annualStatSelStn[1],col="red",pch=21,cex=fontsize)									 
		par(mfg=c(1,1))
		boxplot(mean(annualStatSelStn[2:(nSim+1)]),border=2,lwd=linewidth,
			yaxt='n',cex.main=fontsize,cex.lab=fontsize,cex.axis=fontsize,cex=fontsize)				
		legend("bottom", inset=c(-0.15,-0.15),
			legend = c("observed","simulations mean"),col=c("red","red"),
			lty=c(0,1),lwd=c(linewidth,linewidth+1),pch=c(21,NA),bg = "white", horiz=TRUE,
			cex=fontsize, bty = "n" )									 
	}
}
seasonalStatPlotFun<-function(seasonalStat,main,nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength){
	if (rfStatSelStn=="All stations"){
		if (nStation>=2){
			Season_3ColIndex<-seq(from=4,to=1+nStation*5,by=5)
			Season_4ColIndex<-seq(from=5,to=1+nStation*5,by=5)
			Season_1ColIndex<-seq(from=2,to=1+nStation*5,by=5)
			Season_2ColIndex<-seq(from=3,to=1+nStation*5,by=5)
			Season_3Rep<-apply(seasonalStat[2:(nSim+1),Season_3ColIndex],2,mean)
			Season_4Rep<-apply(seasonalStat[2:(nSim+1),Season_4ColIndex],2,mean)
			Season_1Rep<-apply(seasonalStat[2:(nSim+1),Season_1ColIndex],2,mean)
			Season_2Rep<-apply(seasonalStat[2:(nSim+1),Season_2ColIndex],2,mean)
		}
		Season_3Ob<-seasonalStat[1,Season_3ColIndex]
		Season_4Ob<-seasonalStat[1,Season_4ColIndex]
		Season_1Ob<-seasonalStat[1,Season_1ColIndex]
		Season_2Ob<-seasonalStat[1,Season_2ColIndex]							 		
		par(mfrow = c(2,2),mar = c(4,4,2,1),oma=c(1.5,1.5,3,1),xpd=FALSE,pty="s")	
        qq_au<-qqplot(Season_1Ob, Season_1Rep, plot.it = FALSE)
		plot(qq_au$x,qq_au$y,xlim=1.05*range(qq_au$x,qq_au$y),ylim=1.05*range(qq_au$x,qq_au$y),
		  xlab="",ylab="",asp=1,cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)
		#fit_au <- lm(Season_1Rep ~ Season_1Ob, data = qq_au)
		#abline(fit_au,lty=3)		
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 
		mtext(side = 3, text = "Season_1", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)
	    qq_wi<-qqplot(Season_2Ob, Season_2Rep, plot.it = FALSE)
		plot(qq_wi$x,qq_wi$y,xlim=1.05*range(qq_wi$x,qq_wi$y),ylim=1.05*range(qq_wi$x,qq_wi$y),
		  xlab="",ylab="",asp=1,cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)
		#fit_wi <- lm(Season_2Rep ~ Season_2Ob, data = qq_wi)
		#abline(fit_wi,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = "Season_2", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
  	    mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
	    qq_sp<-qqplot(Season_3Ob, Season_3Rep, plot.it = FALSE)
		plot(qq_sp$x,qq_sp$y,xlim=1.05*range(qq_sp$x,qq_sp$y),ylim=1.05*range(qq_sp$x,qq_sp$y),
		  xlab="",ylab="",asp=1,cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)
		#fit_sp <- lm(Season_3Rep ~ Season_3Ob, data = qq_sp)
		#abline(fit_sp,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = "Season_3", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
		qq_su<-qqplot(Season_4Ob, Season_4Rep, plot.it = FALSE)
		plot(qq_su$x,qq_su$y,xlim=1.05*range(qq_su$x,qq_su$y),ylim=1.05*range(qq_su$x,qq_su$y),
		  xlab="",ylab="",asp=1,cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)
		#fit_su <- lm(Season_4Rep ~ Season_4Ob, data = qq_su)
		#abline(fit_su,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = "Season_4", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)						 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=fontsize+0.3) 							 	
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		#Season_3 statistics at selected stations
		Season_3SelStn<-seasonalStat[,4+(selStn-1)*5]
		Season_4SelStn<-seasonalStat[,5+(selStn-1)*5]
		Season_1SelStn<-seasonalStat[,2+(selStn-1)*5]
		Season_2SelStn<-seasonalStat[,3+(selStn-1)*5]
		ymax_sp<-max(Season_3SelStn)								
		ymin_sp<-min(Season_3SelStn)
		yext_sp<-(ymax_sp-ymin_sp)*0.05
		ymax_su<-max(Season_4SelStn)								
		ymin_su<-min(Season_4SelStn)
		yext_su<-(ymax_su-ymin_su)*0.05							 
		ymax_au<-max(Season_1SelStn)								
		ymin_au<-min(Season_1SelStn)
		yext_au<-(ymax_au-ymin_au)*0.05							 
		ymax_wi<-max(Season_2SelStn)								
		ymin_wi<-min(Season_2SelStn)
		yext_wi<-(ymax_wi-ymin_wi)*0.05						
		
		par(mfrow = c(2,2),mar = c(1.5,2.5,1,1),oma=c(7,2,7,1),xpd=TRUE,pty="s")
		boxplot(Season_1SelStn[2:(nSim+1)],ylim=c(ymin_au-yext_au,ymax_au+yext_au),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)		
        mtext(side = 1, text = "Season_1", line = 0.5,cex=fontsize)									
		points(Season_1SelStn[1],col="red",pch=21,xaxt='n',cex=fontsize)		
        boxplot(Season_2SelStn[2:(nSim+1)],ylim=c(ymin_wi-yext_wi,ymax_wi+yext_wi),
			xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = "Season_2", line = 0.5,cex=fontsize)
		points(Season_2SelStn[1],col="red",pch=21,xaxt='n',cex=fontsize)								 	 		 																	 
		boxplot(Season_3SelStn[2:(nSim+1)],ylim=c(ymin_sp-yext_sp,ymax_sp+yext_sp),
			xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = "Season_3", line = 0.5,cex=fontsize)
		points(Season_3SelStn[1],col="red",pch=21,xaxt='n',cex=fontsize)	
		boxplot(Season_4SelStn[2:(nSim+1)],ylim=c(ymin_su-yext_su,ymax_su+yext_su),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = "Season_4", line = 0.5,cex=fontsize)
		points(Season_4SelStn[1],col="red",pch=21,xaxt='n',cex=fontsize)								 
        par(mfg=c(1,1))
		boxplot(mean(Season_3SelStn[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		boxplot(mean(Season_4SelStn[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(Season_1SelStn[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(Season_2SelStn[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,5,0),xpd=TRUE)
		if (mainLength>30) {
			title(main=paste(main,"\nat station",rfStatSelStn),outer = T,cex.main=fontsize+0.3)
		}
		else {
			title(main=paste(main,"at station",rfStatSelStn),outer = T,cex.main=fontsize+0.3)
		}
		legend("bottom", inset=c(-0.05,-0.05),legend = c("observed","simulations mean"),
			col=c("red","red"),lty=c(0,1),lwd=c(0,linewidth),pch=c(21,NA),
			bg = "white", horiz=TRUE,cex=fontsize,bty="n")							 
		
	}
}
seasonalStatPlotSaveFun<-function(seasonalStat,main,nSim,nStation,rfStatSelStn,stnNumber){
	if (rfStatSelStn=="All stations"){
		if (nStation>=2){
			Season_3ColIndex<-seq(from=4,to=1+nStation*5,by=5)
			Season_4ColIndex<-seq(from=5,to=1+nStation*5,by=5)
			Season_1ColIndex<-seq(from=2,to=1+nStation*5,by=5)
			Season_2ColIndex<-seq(from=3,to=1+nStation*5,by=5)
			Season_3Rep<-apply(seasonalStat[2:(nSim+1),Season_3ColIndex],2,mean)
			Season_4Rep<-apply(seasonalStat[2:(nSim+1),Season_4ColIndex],2,mean)
			Season_1Rep<-apply(seasonalStat[2:(nSim+1),Season_1ColIndex],2,mean)
			Season_2Rep<-apply(seasonalStat[2:(nSim+1),Season_2ColIndex],2,mean)
		}
		Season_3Ob<-seasonalStat[1,Season_3ColIndex]
		Season_4Ob<-seasonalStat[1,Season_4ColIndex]
		Season_1Ob<-seasonalStat[1,Season_1ColIndex]
		Season_2Ob<-seasonalStat[1,Season_2ColIndex]							 		
		par(mfrow = c(2,2),mar = c(3.5,3.5,2,1),oma=c(1.5,1.5,3,1),xpd=FALSE,pty="s")	
        qq_au<-qqplot(Season_1Ob, Season_1Rep, plot.it = FALSE)
		plot(qq_au$x,qq_au$y,xlim=1.05*range(qq_au$x,qq_au$y),ylim=1.05*range(qq_au$x,qq_au$y),
		  xlab="",ylab="",asp=1)
		#fit_au <- lm(Season_1Rep ~ Season_1Ob, data = qq_au)
		#abline(fit_au,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = "Season_1", line = 0.5,cex=1)
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)
	    qq_wi<-qqplot(Season_2Ob, Season_2Rep, plot.it = FALSE)
		plot(qq_wi$x,qq_wi$y,xlim=1.05*range(qq_wi$x,qq_wi$y),ylim=1.05*range(qq_wi$x,qq_wi$y),
		  xlab="",ylab="",asp=1)
		#fit_wi <- lm(Season_2Rep ~ Season_2Ob, data = qq_wi)
		#abline(fit_wi,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = "Season_2", line = 0.5,cex=1)
		mtext(side = 1, text = "Observed", line = 2,cex=1)
  	    mtext(side = 2, text = "Simulated", line = 2,cex=1)							 
	    qq_sp<-qqplot(Season_3Ob, Season_3Rep, plot.it = FALSE)
		plot(qq_sp$x,qq_sp$y,xlim=1.05*range(qq_sp$x,qq_sp$y),ylim=1.05*range(qq_sp$x,qq_sp$y),
		  xlab="",ylab="",asp=1)
		#fit_sp <- lm(Season_3Rep ~ Season_3Ob, data = qq_sp)
		#abline(fit_sp,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = "Season_3", line = 0.5,cex=1)
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)							 
		qq_su<-qqplot(Season_4Ob, Season_4Rep, plot.it = FALSE)
		plot(qq_su$x,qq_su$y,xlim=1.05*range(qq_su$x,qq_su$y),ylim=1.05*range(qq_su$x,qq_su$y),
		  xlab="",ylab="",asp=1)
		#fit_su <- lm(Season_4Rep ~ Season_4Ob, data = qq_su)
		#abline(fit_su,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = "Season_4", line = 0.5,cex=1)
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)						 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=1) 							 		
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		#Season_3 statistics at selected stations
		Season_3SelStn<-seasonalStat[,4+(selStn-1)*5]
		Season_4SelStn<-seasonalStat[,5+(selStn-1)*5]
		Season_1SelStn<-seasonalStat[,2+(selStn-1)*5]
		Season_2SelStn<-seasonalStat[,3+(selStn-1)*5]
		ymax_sp<-max(Season_3SelStn)								
		ymin_sp<-min(Season_3SelStn)
		yext_sp<-(ymax_sp-ymin_sp)*0.05
		ymax_su<-max(Season_4SelStn)								
		ymin_su<-min(Season_4SelStn)
		yext_su<-(ymax_su-ymin_su)*0.05							 
		ymax_au<-max(Season_1SelStn)								
		ymin_au<-min(Season_1SelStn)
		yext_au<-(ymax_au-ymin_au)*0.05							 
		ymax_wi<-max(Season_2SelStn)								
		ymin_wi<-min(Season_2SelStn)
		yext_wi<-(ymax_wi-ymin_wi)*0.05								
		par(mfrow = c(2,2),mar = c(2,2,1,0.5),oma=c(4,1,2,0.5),xpd=FALSE,pty="s")
		boxplot(Season_1SelStn[2:(nSim+1)],ylim=c(ymin_au-yext_au,ymax_au+yext_au),
			 xaxt='n')		
        mtext(side = 1, text = "Season_1", line = 0.5,cex=1)									
		points(Season_1SelStn[1],col="red",pch=21,xaxt='n')	
        boxplot(Season_2SelStn[2:(nSim+1)],ylim=c(ymin_wi-yext_wi,ymax_wi+yext_wi),
			xaxt='n')
		mtext(side = 1, text = "Season_2", line = 0.5,cex=1)
		points(Season_2SelStn[1],col="red",pch=21,xaxt='n')							 	 		 																	 
		boxplot(Season_3SelStn[2:(nSim+1)],ylim=c(ymin_sp-yext_sp,ymax_sp+yext_sp),
			xaxt='n')
		mtext(side = 1, text = "Season_3", line = 0.5,cex=1)
		points(Season_3SelStn[1],col="red",pch=21,xaxt='n')
		boxplot(Season_4SelStn[2:(nSim+1)],ylim=c(ymin_su-yext_su,ymax_su+yext_su),
			 xaxt='n')
		mtext(side = 1, text = "Season_4", line = 0.5,cex=1)
		points(Season_4SelStn[1],col="red",pch=21,xaxt='n')								 
        par(mfg=c(1,1))
		boxplot(mean(Season_3SelStn[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		boxplot(mean(Season_4SelStn[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(Season_1SelStn[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(Season_2SelStn[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main,"at station",rfStatSelStn),outer = T,cex.main=1) 
		legend("bottom", inset=c(-0.1,-0.1),legend = c("observed","simulations mean"),
			col=c("red","red"),lty=c(0,1),lwd=c(0,1),pch=c(21,NA),
			bg = "white", horiz=TRUE,cex=1,bty="n")							 		
	}
}
monthlyStatPlotFun<-function(monthlyStat,main,nSim,nStation,rfStatSelStn,stnNumber,mainLength){	 
	if (rfStatSelStn=="All stations"){
		Ob<-monthlyStat[1,]
	    stn_Ob<-Ob[2:13]#Grab data in Station 1
	    Rep<-apply(monthlyStat[2:(nSim+1),],2,mean)#mean of all simulations
	    stn_Rep<-Rep[2:13]#Grab data in Station 1	
		if (nStation>=2){
			for (iStn in 2:nStation){
				istn_Ob<-Ob[(2+(iStn-1)*12):(13+(iStn-1)*12)]
				istn_Rep<-Rep[(2+(iStn-1)*12):(13+(iStn-1)*12)]
				stn_Rep<-rbind(stn_Rep,istn_Rep)
				stn_Ob<-rbind(stn_Ob,istn_Ob)
			}	
		}
		par(mfrow = c(4,3),mar = c(3,3,2,1),oma=c(2,1,3,0.5),xpd=FALSE,pty="s")							 
		for (i in 1:12){
			qq <-qqplot(stn_Ob[,i], stn_Rep[,i], plot.it = FALSE)
			plot(qq$x,qq$y,xlim=1.05*range(qq$x,qq$y),ylim=1.05*range(qq$x,qq$y)
			,xlab="",ylab="",asp=1,cex.lab=0.8, cex.axis=1,cex=1)
			#fit <- lm(stn_Rep[,i] ~ stn_Ob[,i], data = qq)
			#abline(fit,lty=3,cex=1)	
			#Add a diagonal line to the scatter plot
			lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 			 
			mtext(side = 3, text = substitute(exp, list(exp = month.abb[i])), line = 0.5,cex=0.8)
			mtext(side = 1, text = "Observed", line = 2,cex=0.8)
			mtext(side = 2, text = "Simulated", line = 2,cex=0.8)
		}
		par(mfrow = c(1,1),mar = c(0,0,0,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=1.2) 							 		
	}							
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		monthlyStatSelStn<-monthlyStat[,(2+(selStn-1)*12):(13+(selStn-1)*12)]
        ymax<-max(monthlyStatSelStn)
	    ymin<-min(monthlyStatSelStn)
	    yext<-(ymax-ymin)*0.05	    
        par(mar=c(7,4.5,3,2),oma=c(2,1,1,0.5),xpd=TRUE,pty="s")
		if (mainLength>30) {
		boxplot.matrix(monthlyStatSelStn[2:(1+nSim),],use.cols = TRUE,ylim=c(ymin-yext,ymax+yext),
					xaxt='n',main=paste(main, "\nat station",rfStatSelStn),
					xlab="",ylab="Statistic Value",cex=1.2,cex.lab=1.2,cex.axis=1.2,cex.main=1.2)
		}
		else{
			boxplot.matrix(monthlyStatSelStn[2:(1+nSim),],use.cols = TRUE,ylim=c(ymin-yext,ymax+yext),
					xaxt='n',main=paste(main, "at station",rfStatSelStn),
					xlab="",ylab="Statistic Value",cex=1.2,cex.lab=1.2,cex.axis=1.2,cex.main=1.2)
		}
		axis(1, at = 1:12, labels =month.abb,cex.axis=1.2)
		points(1:12,monthlyStatSelStn[1,],col="red",pch=21,cex=1.2,cex.lab=1.2,cex.axis=1.2)									 							  
		par(mfg=c(1,1))
		boxplot.matrix(matrix(apply(monthlyStatSelStn[2:(1+nSim),],2,mean),nrow=1,ncol=12),use.cols = TRUE,
					ylim=c(ymin-yext,ymax+yext),border=2,lwd=0.5,xaxt='n',xlab="",ylab="",cex=1.2,cex.axis=1.2)						  
	    legend("bottom", inset=c(-0.25,-0.25),legend = c("observed","simulations mean"),col=c("red","red"),
			lty=c(0,1),lwd=c(0,1),pch=c(21,NA),bg = "white", horiz=TRUE,cex=1.2,bty="n")			
	}
}	
monthlyStatPlotSaveFun<-function(monthlyStat,main,nSim,nStation,rfStatSelStn,stnNumber,mainLength){	 
	if (rfStatSelStn=="All stations"){
        Ob<-monthlyStat[1,]
		stn_Ob<-Ob[2:13]#Grab data in Station 1
		Rep<-apply(monthlyStat[2:(nSim+1),],2,mean)#mean of all simulations
		stn_Rep<-Rep[2:13]#Grab data in Station 1						 
		if (nStation>=2){
			for (iStn in 2:nStation){
				istn_Ob<-Ob[(2+(iStn-1)*12):(13+(iStn-1)*12)]
				istn_Rep<-Rep[(2+(iStn-1)*12):(13+(iStn-1)*12)]
				stn_Rep<-rbind(stn_Rep,istn_Rep)
				stn_Ob<-rbind(stn_Ob,istn_Ob)
			}	
		}	
		par(mfrow = c(4,3),mar = c(3,3,2,1),oma=c(0,1,3,0.5),xpd=FALSE,pty="s")							 
		for (i in 1:12){
			qq <-qqplot(stn_Ob[,i], stn_Rep[,i], plot.it = FALSE)
			plot(qq$x,qq$y,xlim=1.05*range(qq$x,qq$y),ylim=1.05*range(qq$x,qq$y)
			,xlab="",ylab="",asp=1,cex.lab=0.8, cex.axis=1,cex=1)
			#fit <- lm(stn_Rep[,i] ~ stn_Ob[,i], data = qq)
			#abline(fit,lty=3,cex=1)	
			#Add a diagonal line to the scatter plot
			lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 			 
			mtext(side = 3, text = substitute(exp, list(exp = month.abb[i])), line = 0.5,cex=0.8)
			mtext(side = 1, text = "Observed", line = 2,cex=0.8)
			mtext(side = 2, text = "Simulated", line = 2,cex=0.8)
		}
		par(mfrow = c(1,1),mar = c(0,0,0,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=1.2) 							 		
	}							
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		monthlyStatSelStn<-monthlyStat[,(2+(selStn-1)*12):(13+(selStn-1)*12)]
        ymax<-max(monthlyStatSelStn)
	    ymin<-min(monthlyStatSelStn)
	    yext<-(ymax-ymin)*0.05	    
        par(mar=c(6,4.5,3,2),oma=c(1,1,1,0.5),xpd=TRUE,pty="s")
		if (mainLength>30){
			boxplot.matrix(monthlyStatSelStn[2:(1+nSim),],use.cols = TRUE,ylim=c(ymin-yext,ymax+yext),
						xaxt='n',main=paste(main, "\nat station",rfStatSelStn),
						xlab="",ylab="Statistic Value",cex=1.2,cex.lab=1.2,cex.axis=1.2,cex.main=1.2)
		}
		else {
			boxplot.matrix(monthlyStatSelStn[2:(1+nSim),],use.cols = TRUE,ylim=c(ymin-yext,ymax+yext),
				xaxt='n',main=paste(main, "at station",rfStatSelStn),
				xlab="",ylab="Statistic Value",cex=1.2,cex.lab=1.2,cex.axis=1.2,cex.main=1.2)
		}
		axis(1, at = 1:12, labels =month.abb,cex.axis=1.2)
		points(1:12,monthlyStatSelStn[1,],col="red",pch=21,cex=1.2,cex.lab=1.2,cex.axis=1.2)									 							  
		par(mfg=c(1,1))
		boxplot.matrix(matrix(apply(monthlyStatSelStn[2:(1+nSim),],2,mean),nrow=1,ncol=12),use.cols = TRUE,
					ylim=c(ymin-yext,ymax+yext),border=2,lwd=0.5,xaxt='n',xlab="",ylab="",cex=1.2,cex.axis=1.2)						  
	    legend("bottom", inset=c(-0.25,-0.25),legend = c("observed","simulations mean"),col=c("red","red"),
			lty=c(0,1),lwd=c(0,1),pch=c(21,NA),bg = "white", horiz=TRUE,cex=1.2,bty="n")			
	}
}	
totRfAmtInWSPlotFun<-function(totRfAmtInWS,text1,text2,text3,text4,main,nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth){
	if (nStation==1){
		ColInd_1<-2 #length = 1 day 
		ColInd_2<-3 #length = 2-4 days 
		ColInd_3<-4 #length = 5-7 days 
		ColInd_4<-5 #length >7 days 
		Rep_1<-totRfAmtInWS[2:(nSim+1),ColInd_1]
		Rep_2<-totRfAmtInWS[2:(nSim+1),ColInd_2]
		Rep_3<-totRfAmtInWS[2:(nSim+1),ColInd_3]
		Rep_4<-totRfAmtInWS[2:(nSim+1),ColInd_4]			
	}
	if (nStation>=2){
		ColInd_1<-seq(from=2,to=1+nStation*4,by=4) #length = 1 day 
		ColInd_2<-seq(from=3,to=1+nStation*4,by=4) #length = 2-4 days 
		ColInd_3<-seq(from=4,to=1+nStation*4,by=4) #length = 5-7 days 
		ColInd_4<-seq(from=5,to=1+nStation*4,by=4) #length >7 days 
		Rep_1<-apply(totRfAmtInWS[2:(nSim+1),ColInd_1],2,mean)
		Rep_2<-apply(totRfAmtInWS[2:(nSim+1),ColInd_2],2,mean)
		Rep_3<-apply(totRfAmtInWS[2:(nSim+1),ColInd_3],2,mean)
		Rep_4<-apply(totRfAmtInWS[2:(nSim+1),ColInd_4],2,mean)	
	}	
	Ob_1<-totRfAmtInWS[1,ColInd_1]
	Ob_2<-totRfAmtInWS[1,ColInd_2]
	Ob_3<-totRfAmtInWS[1,ColInd_3]
	Ob_4<-totRfAmtInWS[1,ColInd_4]
	if (rfStatSelStn=="All stations"){		
		par(mfrow = c(2,2),mar = c(4,4,2,1),oma=c(1.5,1.5,3,1),xpd=FALSE,pty="s")
	    qq_1<-qqplot(Ob_1, Rep_1, plot.it = FALSE)
		plot(qq_1$x,qq_1$y,xlim=1.05*range(qq_1$x,qq_1$y),ylim=1.05*range(qq_1$x,qq_1$y),
		  xlab="",ylab="",asp=1,cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		#fit_1 <- lm(Rep_1 ~ Ob_1, data = qq_1)
		#abline(fit_1,lty=3)		
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = paste(text1), line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
	    qq_2<-qqplot(Ob_2, Rep_2, plot.it = FALSE)
		plot(qq_2$x,qq_2$y,xlim=1.05*range(qq_2$x,qq_2$y),ylim=1.05*range(qq_2$x,qq_2$y),
		  xlab="",ylab="",asp=1,cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		#fit_2 <- lm(Rep_2 ~ Ob_2, data = qq_2)
		#abline(fit_2,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = paste(text2), line = 0.5,cex=fontsize)	
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
   	    qq_3<-qqplot(Ob_3, Rep_3, plot.it = FALSE)
		plot(qq_3$x,qq_3$y,xlim=1.05*range(qq_3$x,qq_3$y),ylim=1.05*range(qq_3$x,qq_3$y),
		  xlab="",ylab="",asp=1,cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		#fit_3 <- lm(Rep_3 ~ Ob_3, data = qq_3)
		#abline(fit_3,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = paste(text3), line = 0.5,cex=fontsize)	
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
		qq_4<-qqplot(Ob_4, Rep_4, plot.it = FALSE)
		plot(qq_4$x,qq_4$y,xlim=1.05*range(qq_4$x,qq_4$y),ylim=1.05*range(qq_4$x,qq_4$y),
		  xlab="",ylab="",asp=1,cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		#fit_4 <- lm(Rep_4 ~ Ob_4, data = qq_4)
		#abline(fit_4,lty=3)		
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = paste(text4), line = 0.5,cex=fontsize)								 
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)								 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=fontsize+0.3) 							 								  						 												 
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		SelStn_1<-totRfAmtInWS[,2+(selStn-1)*4]
		SelStn_2<-totRfAmtInWS[,3+(selStn-1)*4]
		SelStn_3<-totRfAmtInWS[,4+(selStn-1)*4]
		SelStn_4<-totRfAmtInWS[,5+(selStn-1)*4]
		ymax_1<-max(SelStn_1)								
		ymin_1<-min(SelStn_1)
		yext_1<-(ymax_1-ymin_1)*0.05							 
		ymax_2<-max(SelStn_2)								
		ymin_2<-min(SelStn_2)
		yext_2<-(ymax_2-ymin_2)*0.05							 
		ymax_3<-max(SelStn_3)								
		ymin_3<-min(SelStn_3)
		yext_3<-(ymax_3-ymin_3)*0.05							 
		ymax_4<-max(SelStn_4)								
		ymin_4<-min(SelStn_4)
		yext_4<-(ymax_4-ymin_4)*0.05			
		par(mfrow = c(2,2),mar = c(1.5,2,1,1),oma=c(7,2,7,1),xpd=TRUE,pty="s")						 	 		 																	 
		boxplot(SelStn_1[2:(nSim+1)],ylim=c(ymin_1-yext_1,ymax_1+yext_1),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = paste(text1), line = 0.5,cex=fontsize)
		points(SelStn_1[1],col="red",pch=21,xaxt='n',cex=fontsize)
		boxplot(SelStn_2[2:(nSim+1)],ylim=c(ymin_2-yext_2,ymax_2+yext_2),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = paste(text2), line = 0.5,cex=fontsize)
		points(SelStn_2[1],col="red",pch=21,xaxt='n',cex=fontsize)								 							 
		boxplot(SelStn_3[2:(nSim+1)],ylim=c(ymin_3-yext_3,ymax_3+yext_3),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)		
        mtext(side = 1, text = paste(text3), line = 0.5,cex=fontsize)									
		points(SelStn_3[1],col="red",pch=21,xaxt='n',cex=fontsize)
        boxplot(SelStn_4[2:(nSim+1)],ylim=c(ymin_4-yext_4,ymax_4+yext_4),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = paste(text4), line = 0.5,cex=fontsize)
		points(SelStn_4[1],col="red",pch=21,xaxt='n',cex=fontsize)
		par(mfg=c(1,1))
		boxplot(mean(SelStn_1[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		boxplot(mean(SelStn_2[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(SelStn_3[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(SelStn_4[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,5,0),xpd=TRUE)
		title(main=paste(main, "\nat station",rfStatSelStn),outer = T,cex.main=fontsize+0.3) 							 
		legend("bottom", inset=c(-0.05,-0.05),legend = c("observed","simulations mean"),
			col=c("red","red"),lty=c(0,1),lwd=c(0,linewidth),pch=c(21,NA),
			bg = "white", horiz=TRUE,cex=fontsize,bty="n")		
	}
}			
totRfAmtInWSPlotSaveFun<-function(totRfAmtInWS,text1,text2,text3,text4,main,nSim,nStation,rfStatSelStn,stnNumber){


	if (nStation==1){
		ColInd_1<-2 #length = 1 day 
		ColInd_2<-3 #length = 2-4 days 
		ColInd_3<-4 #length = 5-7 days 
		ColInd_4<-5 #length >7 days 
		Rep_1<-totRfAmtInWS[2:(nSim+1),ColInd_1]
		Rep_2<-totRfAmtInWS[2:(nSim+1),ColInd_2]
		Rep_3<-totRfAmtInWS[2:(nSim+1),ColInd_3]
		Rep_4<-totRfAmtInWS[2:(nSim+1),ColInd_4]			
	}
	if (nStation>=2){
		ColInd_1<-seq(from=2,to=1+nStation*4,by=4) #length = 1 day 
		ColInd_2<-seq(from=3,to=1+nStation*4,by=4) #length = 2-4 days 
		ColInd_3<-seq(from=4,to=1+nStation*4,by=4) #length = 5-7 days 
		ColInd_4<-seq(from=5,to=1+nStation*4,by=4) #length >7 days 
		Rep_1<-apply(totRfAmtInWS[2:(nSim+1),ColInd_1],2,mean)
		Rep_2<-apply(totRfAmtInWS[2:(nSim+1),ColInd_2],2,mean)
		Rep_3<-apply(totRfAmtInWS[2:(nSim+1),ColInd_3],2,mean)
		Rep_4<-apply(totRfAmtInWS[2:(nSim+1),ColInd_4],2,mean)			
	}					 
	Ob_1<-totRfAmtInWS[1,ColInd_1]
	Ob_2<-totRfAmtInWS[1,ColInd_2]
	Ob_3<-totRfAmtInWS[1,ColInd_3]
	Ob_4<-totRfAmtInWS[1,ColInd_4]
	if (rfStatSelStn=="All stations"){		
		par(mfrow = c(2,2),mar = c(3.5,3.5,2,1),oma=c(1.5,1.5,3,1),xpd=FALSE,pty="s")
	    qq_1<-qqplot(Ob_1, Rep_1, plot.it = FALSE)
		plot(qq_1$x,qq_1$y,xlim=1.05*range(qq_1$x,qq_1$y),ylim=1.05*range(qq_1$x,qq_1$y),
		  xlab="",ylab="",asp=1)
		#fit_1 <- lm(Rep_1 ~ Ob_1, data = qq_1)
		#abline(fit_1,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = paste(text1), line = 0.5,cex=1)
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)							 
	    qq_2<-qqplot(Ob_2, Rep_2, plot.it = FALSE)
		plot(qq_2$x,qq_2$y,xlim=1.05*range(qq_2$x,qq_2$y),ylim=1.05*range(qq_2$x,qq_2$y),
		  xlab="",ylab="",asp=1)
		#fit_2 <- lm(Rep_2 ~ Ob_2, data = qq_2)
		#abline(fit_2,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = paste(text2), line = 0.5,cex=1)	
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)							 
   	    qq_3<-qqplot(Ob_3, Rep_3, plot.it = FALSE)
		plot(qq_3$x,qq_3$y,xlim=1.05*range(qq_3$x,qq_3$y),ylim=1.05*range(qq_3$x,qq_3$y),
		  xlab="",ylab="",asp=1)
		#fit_3 <- lm(Rep_3 ~ Ob_3, data = qq_3)
		#abline(fit_3,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = paste(text3), line = 0.5,cex=1)	
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)							 
		qq_4<-qqplot(Ob_4, Rep_4, plot.it = FALSE)
		plot(qq_4$x,qq_4$y,xlim=1.05*range(qq_4$x,qq_4$y),ylim=1.05*range(qq_4$x,qq_4$y),
		  xlab="",ylab="",asp=1)
		#fit_4 <- lm(Rep_4 ~ Ob_4, data = qq_4)
		#abline(fit_4,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = paste(text4), line = 0.5,cex=1)								 
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)								 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=1) 							 								  						 												 
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		SelStn_1<-totRfAmtInWS[,2+(selStn-1)*4]
		SelStn_2<-totRfAmtInWS[,3+(selStn-1)*4]
		SelStn_3<-totRfAmtInWS[,4+(selStn-1)*4]
		SelStn_4<-totRfAmtInWS[,5+(selStn-1)*4]
		ymax_1<-max(SelStn_1)								
		ymin_1<-min(SelStn_1)
		yext_1<-(ymax_1-ymin_1)*0.05							 
		ymax_2<-max(SelStn_2)								
		ymin_2<-min(SelStn_2)
		yext_2<-(ymax_2-ymin_2)*0.05							 
		ymax_3<-max(SelStn_3)								
		ymin_3<-min(SelStn_3)
		yext_3<-(ymax_3-ymin_3)*0.05							 
		ymax_4<-max(SelStn_4)								
		ymin_4<-min(SelStn_4)
		yext_4<-(ymax_4-ymin_4)*0.05			
		par(mfrow = c(2,2),mar = c(2,2,1,0.5),oma=c(4,1,2,0.5),xpd=TRUE,pty="s")					 	 		 																	 
		boxplot(SelStn_1[2:(nSim+1)],ylim=c(ymin_1-yext_1,ymax_1+yext_1),
			 xaxt='n')
		mtext(side = 1, text = paste(text1), line = 0.5,cex=1)
		points(SelStn_1[1],col="red",pch=21,xaxt='n')
		boxplot(SelStn_2[2:(nSim+1)],ylim=c(ymin_2-yext_2,ymax_2+yext_2),
			 xaxt='n')
		mtext(side = 1, text = paste(text2), line = 0.5,cex=1)
		points(SelStn_2[1],col="red",pch=21,xaxt='n')							 							 
		boxplot(SelStn_3[2:(nSim+1)],ylim=c(ymin_3-yext_3,ymax_3+yext_3),
			 xaxt='n')		
        mtext(side = 1, text = paste(text3), line = 0.5,cex=1)									
		points(SelStn_3[1],col="red",pch=21,xaxt='n')	
        boxplot(SelStn_4[2:(nSim+1)],ylim=c(ymin_4-yext_4,ymax_4+yext_4),
			 xaxt='n')
		mtext(side = 1, text = paste(text4), line = 0.5,cex=1)
		points(SelStn_4[1],col="red",pch=21,xaxt='n')
		par(mfg=c(1,1))
		boxplot(mean(SelStn_1[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		boxplot(mean(SelStn_2[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(SelStn_3[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(SelStn_4[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main, "at station",rfStatSelStn),outer = T,cex.main=1) 							 
		legend("bottom", inset=c(-0.1,-0.1),legend = c("observed","simulations mean"),col=c("red","red"),lty=c(0,1),lwd=c(0,1),pch=c(21,NA),
			bg = "white", horiz=TRUE,cex=1,bty="n")		
	}
}


rfStatInAYearPlotFun<-function(scanIndex1,scanIndex2,scanIndex3,main,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength){
	 #scanIndex1<-1,scanIndex2<-0,scanIndex3<-2 for number of wet days in a year
	 #scanIndex1<-3,scanIndex2<-0,scanIndex3<-2 for maximum wet spell length in a year
	 #scanIndex1<-5,scanIndex2<-0,scanIndex3<-1 for maximum dry spell length in a year
	 #scanIndex1<-4,scanIndex2<-0,scanIndex3<-2 for average number of wet spells>1 in a year
	 #scanIndex1<-5,scanIndex1<-0,scanIndex3<-1 for average number of dry spells >1 in a year
	 #scanIndex1<-0,scanIndex2<-0,scanIndex3<-2 for max rf amt in a year
	 #scanIndex1<-2,scanIndex2<-0,scanIndex3<-2 for avg rf amt in a year
	 if (rfStatSelStn=="All stations"){
		iStn<-1
		if (nYrStat %% 2 ==0){
			med_RfStat<-apply(matrix(scan(file=statFile,
				skip=(iStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3+(nYrStat/2-1),nlines=2,quiet = TRUE),
				nrow=2,ncol=8,byrow=TRUE),2,median)
		}
		else{
			med_RfStat<-matrix(scan(file=statFile,
				skip=(iStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3+(nYrStat-1)/2,nlines=1,quiet = TRUE),
				nrow=1,ncol=8,byrow=TRUE)
		}	
		if (nStation>=2){
			for (iStn in 2:nStation){ 
				if (nYrStat %% 2 ==0){
					imed_RfStat<-apply(matrix(scan(file=statFile,
						skip=(iStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3+(nYrStat/2-1),nlines=2,quiet = TRUE),
						nrow=2,ncol=8,byrow=TRUE),2,median)
				}
				else{
					imed_RfStat<-matrix(scan(file=statFile,
						skip=(iStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3+(nYrStat-1)/2,nlines=1,quiet = TRUE),
						nrow=1,ncol=8,byrow=TRUE)
				}								   
				med_RfStat<-rbind(med_RfStat,imed_RfStat)						
			}
		}
		med_RfStatRep<-med_RfStat[,7]
		med_RfStatOb<-med_RfStat[,5]
		qq<-qqplot(med_RfStatOb, med_RfStatRep, plot.it = FALSE)		
		par(pty="s")
		plot(qq$x,qq$y,xlim=1.05*range(qq$x,qq$y),ylim=1.05*range(qq$x,qq$y),
		  xlab = "Median of Observed",ylab = "Simulated",lwd=linewidth,
		  main=paste(main),asp=1,cex.main=fontsize,
		  cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit <- lm(med_RfStatRep ~ med_RfStatOb, data = qq)
		#abline(fit,lty=3,cex=1.2)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,lwd=linewidth,cex=fontsize)		 		
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		if (nStation==1){
			RfStatInAYearSelStn<-matrix(scan(file=statFile,
				skip=(selStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+2+4*1+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3,nlines=nYrStat,quiet = TRUE),
				nrow=nYrStat,ncol=8,byrow=TRUE)
		}
		if (nStation>=2){
			RfStatInAYearSelStn<-matrix(scan(file=statFile,
				skip=(selStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3,nlines=nYrStat,quiet = TRUE),
				nrow=nYrStat,ncol=8,byrow=TRUE)
		}
		ymax<-max(RfStatInAYearSelStn[,5:8])
		ymin<-min(RfStatInAYearSelStn[,5:8])
		yRange<-ymax-ymin	
		xmax<-max(RfStatInAYearSelStn[,3:4])
		xmin<-min(RfStatInAYearSelStn[,3:4])														 
        par(mar=c(6,3,4,2),xpd=TRUE,pty="s")
		if (mainLength>30) {
			plot(RfStatInAYearSelStn[,3],RfStatInAYearSelStn[,5],xlim=c(xmin,xmax),ylim=c(ymin-0.05*yRange,ymax+0.07*yRange),
				col="black",pch=21,xaxt='n',lwd=linewidth,main=paste(main,"\nat station",rfStatSelStn),
				xlab="Cumulative Probability (%)",ylab="",cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		}
		else {
			plot(RfStatInAYearSelStn[,3],RfStatInAYearSelStn[,5],xlim=c(xmin,xmax),ylim=c(ymin-0.05*yRange,ymax+0.07*yRange),
				col="black",pch=21,xaxt='n',lwd=linewidth,main=paste(main,"at station",rfStatSelStn),
				xlab="Cumulative Probability (%)",ylab="",cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		}
		lines(RfStatInAYearSelStn[,4],RfStatInAYearSelStn[,6],col="red",lty=2,lwd=linewidth,xaxt='n',cex=fontsize)
		lines(RfStatInAYearSelStn[,4],RfStatInAYearSelStn[,7],col="black",lty=1,lwd=linewidth,xaxt='n',cex=fontsize)
		lines(RfStatInAYearSelStn[,4],RfStatInAYearSelStn[,8],col="red",lty=2,lwd=linewidth,xaxt='n',cex=fontsize)
		xTickLocation<-ceiling(xmin*10):floor(xmax*10)
		axis(1, at = xTickLocation/10, labels =paste(xTickLocation*10,"%"),cex=fontsize,cex.axis=fontsize)	
		legend("topright", legend = c("observed","5%th simulated","50%th simulated","95%th simulated"),
			col=c("black","red","black","red"),lty=c(0,2,1,2),lwd=c(linewidth,linewidth,linewidth,linewidth),
			pch=c(21,NA,NA,NA),bg = "white",ncol=1,cex=fontsize,bty="n")
		
	}
}	
#Plot maxm wet & dry spell lengths & 5th% rf amt 
maxSpelllength5thRfAmtPlotFun<-function(maxSpelllength5thRfAmt,fromCol,main,nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength){
	#plot the maxm wet & dry spell length
	#fromCol=2 for maximum wet spell length
	#fromCol=3 for maxium dry spell length
	#fromCol=4 for 5th rf amt
	if (rfStatSelStn=="All stations"){
		#ColIndex<-seq(from=2,to=1+nStation*3,by=3)#maximum wet spell length
		#ColIndex<-seq(from=3,to=1+nStation*3,by=3)#maximum dry spell length
		#ColIndex<-seq(from=4,to=1+nStation*3,by=3)#5th rf amt
		ColIndex<-seq(from=fromCol,to=1+nStation*3,by=3)
		Rep<-apply(maxSpelllength5thRfAmt[2:(nSim+1),ColIndex],2,mean)
		Ob<-maxSpelllength5thRfAmt[1,ColIndex]						 
		qq<-qqplot(Ob, Rep, plot.it = FALSE)		
		par(pty="s")
		plot(qq$x,qq$y,xlim=1.05*range(qq$x,qq$y),ylim=1.05*range(qq$x,qq$y),
		 xlab = "Observed",ylab = "Simulated",main=main,asp=1,lwd=linewidth,
		 cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit <- lm(Rep ~ Ob, data = qq)
		#abline(fit,lty=3,cex=1.2)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 		
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)		 
		#maxSpelllengthSelStn<-maxSpelllength5thRfAmt[,2+(selStn-1)*3]#maximum wet spell length
		#maxSpelllengthSelStn<-maxSpelllength5thRfAmt[,3+(selStn-1)*3]#maximum dry spell length
		#maxSpelllengthSelStn<-maxSpelllength5thRfAmt[,4+(selStn-1)*3]#5th rf amt
	    maxSpelllength5thRfAmtSelStn<-maxSpelllength5thRfAmt[,fromCol+(selStn-1)*3]
		ymax<-max(maxSpelllength5thRfAmtSelStn)
		ymin<-min(maxSpelllength5thRfAmtSelStn)
		yext<-(ymax-ymin)*0.05	    
        par(mar=c(5,6,4,4),xpd=TRUE,pty="s")
		if (mainLength>30){
			boxplot(maxSpelllength5thRfAmtSelStn[2:(nSim+1)],ylim=c(ymin-yext,ymax+yext),xaxt='n',
				main=paste(main, "\nat station",rfStatSelStn),cex.main=fontsize,lwd=linewidth,
				xlab="",ylab="Statistic Value",cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		}
		else{
			boxplot(maxSpelllength5thRfAmtSelStn[2:(nSim+1)],ylim=c(ymin-yext,ymax+yext),xaxt='n',
				main=paste(main, "at station",rfStatSelStn),cex.main=fontsize,lwd=linewidth,
				xlab="",ylab="Statistic Value",cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		}
		points(maxSpelllength5thRfAmtSelStn[1],col="red",pch=21,cex=fontsize)									 
		par(mfg=c(1,1),pty="s")
		boxplot(mean(maxSpelllength5thRfAmtSelStn[2:(nSim+1)]),border=2,lwd=linewidth,yaxt='n',
			cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)	
		legend("bottom", inset=c(-0.15,-0.15),legend = c("observed","simulations mean"),col=c("red","red"),
			lty=c(0,1),lwd=c(linewidth,linewidth+1),pch=c(21,NA),bg = "white", horiz=TRUE,cex=fontsize, bty = "n" )					
	}	
}		
avgOccW_DSpellsPlotFun<-function(avgOccW_DSpells,text1,text2,text3,text4,main,nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth){
	if (nStation==1){
		ColInd_1<-2 #length = 1 day for WS and DS
		ColInd_2<-3 #length = 2-4 days for WS and 2-9 days for DS
		ColInd_3<-4 #length = 5-7 days for WS and 9-18 days for DS
		ColInd_4<-5 #length >7 days for WS and >18 days for DS
		Rep_1<-avgOccW_DSpells[2:(nSim+1),ColInd_1]
		Rep_2<-avgOccW_DSpells[2:(nSim+1),ColInd_2]
		Rep_3<-avgOccW_DSpells[2:(nSim+1),ColInd_3]
		Rep_4<-avgOccW_DSpells[2:(nSim+1),ColInd_4]		
	}
	if (nStation>=2){
		ColInd_1<-seq(from=2,to=1+nStation*4,by=4) #length = 1 day for WS and DS
		ColInd_2<-seq(from=3,to=1+nStation*4,by=4) #length = 2-4 days for WS and 2-9 days for DS
		ColInd_3<-seq(from=4,to=1+nStation*4,by=4) #length = 5-7 days for WS and 9-18 days for DS
		ColInd_4<-seq(from=5,to=1+nStation*4,by=4) #length >7 days for WS and >18 days for DS
		Rep_1<-apply(avgOccW_DSpells[2:(nSim+1),ColInd_1],2,mean)
		Rep_2<-apply(avgOccW_DSpells[2:(nSim+1),ColInd_2],2,mean)
		Rep_3<-apply(avgOccW_DSpells[2:(nSim+1),ColInd_3],2,mean)
		Rep_4<-apply(avgOccW_DSpells[2:(nSim+1),ColInd_4],2,mean)		
	}					 
	Ob_1<-avgOccW_DSpells[1,ColInd_1]
	Ob_2<-avgOccW_DSpells[1,ColInd_2]
	Ob_3<-avgOccW_DSpells[1,ColInd_3]
	Ob_4<-avgOccW_DSpells[1,ColInd_4]
	if (rfStatSelStn=="All stations"){		
		par(mfrow = c(2,2),mar = c(4,4,2,1),oma=c(1.5,1.5,3,1),xpd=FALSE,pty="s")
        qq_1<-qqplot(Ob_1, Rep_1, plot.it = FALSE)
		plot(qq_1$x,qq_1$y,xlim=1.05*range(qq_1$x,qq_1$y),ylim=1.05*range(qq_1$x,qq_1$y),
		  xlab="",ylab="",cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		#fit_1 <- lm(Rep_1 ~ Ob_1, data = qq_1)
		#abline(fit_1,lty=3)		
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = paste(text1), line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
	    qq_2<-qqplot(Ob_2, Rep_2, plot.it = FALSE)
		plot(qq_2$x,qq_2$y,xlim=1.05*range(qq_2$x,qq_2$y),ylim=1.05*range(qq_2$x,qq_2$y),
		  xlab="",ylab="",cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		#fit_2 <- lm(Rep_2 ~ Ob_2, data = qq_2)
		#abline(fit_2,lty=3)		
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)			 
		mtext(side = 3, text = paste(text2), line = 0.5,cex=fontsize)	
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
   	    qq_3<-qqplot(Ob_3, Rep_3, plot.it = FALSE)
		plot(qq_3$x,qq_3$y,xlim=1.05*range(qq_3$x,qq_3$y),ylim=1.05*range(qq_3$x,qq_3$y),
		  xlab="",ylab="",cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		#fit_3 <- lm(Rep_3 ~ Ob_3, data = qq_3)
		#abline(fit_3,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)			 		 
		mtext(side = 3, text = paste(text3), line = 0.5,cex=fontsize)	
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
		qq_4<-qqplot(Ob_4, Rep_4, plot.it = FALSE)
		plot(qq_4$x,qq_4$y,xlim=1.05*range(qq_4$x,qq_4$y),ylim=1.05*range(qq_4$x,qq_4$y),
		  xlab="",ylab="",cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		#fit_4 <- lm(Rep_4 ~ Ob_4, data = qq_4)
		#abline(fit_4,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 		 
		mtext(side = 3, text = paste(text4), line = 0.5,cex=fontsize)								 
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)								 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=fontsize+0.3) 							 								  						 												 
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		SelStn_1<-avgOccW_DSpells[,2+(selStn-1)*4]
		SelStn_2<-avgOccW_DSpells[,3+(selStn-1)*4]
		SelStn_3<-avgOccW_DSpells[,4+(selStn-1)*4]
		SelStn_4<-avgOccW_DSpells[,5+(selStn-1)*4]
		ymax_1<-max(SelStn_1)								
		ymin_1<-min(SelStn_1)
		yext_1<-(ymax_1-ymin_1)*0.05							 
		ymax_2<-max(SelStn_2)								
		ymin_2<-min(SelStn_2)
		yext_2<-(ymax_2-ymin_2)*0.05							 
		ymax_3<-max(SelStn_3)								
		ymin_3<-min(SelStn_3)
		yext_3<-(ymax_3-ymin_3)*0.05							 
		ymax_4<-max(SelStn_4)								
		ymin_4<-min(SelStn_4)
		yext_4<-(ymax_4-ymin_4)*0.05						
		par(mfrow = c(2,2),mar = c(1.5,2,1,1),oma=c(7,2,7,1),xpd=TRUE,pty="s")							 	 		 																	 
		boxplot(SelStn_1[2:(nSim+1)],ylim=c(ymin_1-yext_1,ymax_1+yext_1),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = paste(text1), line = 0.5,cex=fontsize)
		points(SelStn_1[1],col="red",pch=21,xaxt='n',ces=fontsize)
		boxplot(SelStn_2[2:(nSim+1)],ylim=c(ymin_2-yext_2,ymax_2+yext_2),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = paste(text2), line = 0.5,cex=fontsize)
		points(SelStn_2[1],col="red",pch=21,xaxt='n',ces=fontsize)							 							 
		boxplot(SelStn_3[2:(nSim+1)],ylim=c(ymin_3-yext_3,ymax_3+yext_3),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)			
        mtext(side = 1, text = paste(text3), line = 0.5,cex=fontsize)									
		points(SelStn_3[1],col="red",pch=21,xaxt='n',ces=fontsize)	
        boxplot(SelStn_4[2:(nSim+1)],ylim=c(ymin_4-yext_4,ymax_4+yext_4),
			 xaxt='n',cex=fontsize,cex.lab=fontsize,cex.axis=fontsize,lwd=linewidth)	
		mtext(side = 1, text = paste(text4), line = 0.5,cex=fontsize)
		points(SelStn_4[1],col="red",pch=21,xaxt='n',ces=fontsize)
		par(mfg=c(1,1))
		boxplot(mean(SelStn_1[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		boxplot(mean(SelStn_2[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(SelStn_3[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(SelStn_4[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,5,0),xpd=TRUE)
		#Main title is written in two lines
		title(main=paste(main, c("","at station"),c("",rfStatSelStn)),outer = T,cex.main=fontsize+0.3) 							 
		legend("bottom", inset=c(-0.1,-0.1),legend = c("observed","simulations mean"),
			col=c("red","red"),lty=c(0,1),lwd=c(0,linewidth),pch=c(21,NA),
			bg = "white", horiz=TRUE,cex=fontsize,bty="n")		
	}
}	
avgOccW_DSpellsPlotSaveFun<-function(avgOccW_DSpells,text1,text2,text3,text4,main,nSim,nStation,rfStatSelStn,stnNumber){
	if (nStation==1){
		ColInd_1<-2 #length = 1 day for WS and DS
		ColInd_2<-3 #length = 2-4 days for WS and 2-9 days for DS
		ColInd_3<-4 #length = 5-7 days for WS and 9-18 days for DS
		ColInd_4<-5 #length >7 days for WS and >18 days for DS
		Rep_1<-avgOccW_DSpells[2:(nSim+1),ColInd_1]
		Rep_2<-avgOccW_DSpells[2:(nSim+1),ColInd_2]
		Rep_3<-avgOccW_DSpells[2:(nSim+1),ColInd_3]
		Rep_4<-avgOccW_DSpells[2:(nSim+1),ColInd_4]
	}
	if (nStation>=2){
		ColInd_1<-seq(from=2,to=1+nStation*4,by=4) #length = 1 day for WS and DS
		ColInd_2<-seq(from=3,to=1+nStation*4,by=4) #length = 2-4 days for WS and 2-9 days for DS
		ColInd_3<-seq(from=4,to=1+nStation*4,by=4) #length = 5-7 days for WS and 9-18 days for DS
		ColInd_4<-seq(from=5,to=1+nStation*4,by=4) #length >7 days for WS and >18 days for DS
		Rep_1<-apply(avgOccW_DSpells[2:(nSim+1),ColInd_1],2,mean)
		Rep_2<-apply(avgOccW_DSpells[2:(nSim+1),ColInd_2],2,mean)
		Rep_3<-apply(avgOccW_DSpells[2:(nSim+1),ColInd_3],2,mean)
		Rep_4<-apply(avgOccW_DSpells[2:(nSim+1),ColInd_4],2,mean)	
	}


					 
	Ob_1<-avgOccW_DSpells[1,ColInd_1]
	Ob_2<-avgOccW_DSpells[1,ColInd_2]
	Ob_3<-avgOccW_DSpells[1,ColInd_3]
	Ob_4<-avgOccW_DSpells[1,ColInd_4]
	if (rfStatSelStn=="All stations"){		
		par(mfrow = c(2,2),mar = c(3.5,3.5,2,1),oma=c(1.5,1.5,3,1),xpd=FALSE,pty="s")
        qq_1<-qqplot(Ob_1, Rep_1, plot.it = FALSE)
		plot(qq_1$x,qq_1$y,xlim=1.05*range(qq_1$x,qq_1$y),ylim=1.05*range(qq_1$x,qq_1$y),
		  xlab="",ylab="")
		#fit_1 <- lm(Rep_1 ~ Ob_1, data = qq_1)
		#abline(fit_1,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = paste(text1), line = 0.5,cex=1)
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)							 
	    qq_2<-qqplot(Ob_2, Rep_2, plot.it = FALSE)
		plot(qq_2$x,qq_2$y,xlim=1.05*range(qq_2$x,qq_2$y),ylim=1.05*range(qq_2$x,qq_2$y),
		  xlab="",ylab="")
		#fit_2 <- lm(Rep_2 ~ Ob_2, data = qq_2)
		#abline(fit_2,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = paste(text2), line = 0.5,cex=1)	
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)							 
   	    qq_3<-qqplot(Ob_3, Rep_3, plot.it = FALSE)
		plot(qq_3$x,qq_3$y,xlim=1.05*range(qq_3$x,qq_3$y),ylim=1.05*range(qq_3$x,qq_3$y),
		  xlab="",ylab="")
		#fit_3 <- lm(Rep_3 ~ Ob_3, data = qq_3)
		#abline(fit_3,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = paste(text3), line = 0.5,cex=1)	
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)							 
		qq_4<-qqplot(Ob_4, Rep_4, plot.it = FALSE)
		plot(qq_4$x,qq_4$y,xlim=1.05*range(qq_4$x,qq_4$y),ylim=1.05*range(qq_4$x,qq_4$y),
		  xlab="",ylab="")
		#fit_4 <- lm(Rep_4 ~ Ob_4, data = qq_4)
		#abline(fit_4,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=1.2)		 		 
		mtext(side = 3, text = paste(text4), line = 0.5,cex=1)								 
		mtext(side = 1, text = "Observed", line = 2,cex=1)
		mtext(side = 2, text = "Simulated", line = 2,cex=1)								 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=1) 							 								  						 												 
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		SelStn_1<-avgOccW_DSpells[,2+(selStn-1)*4]
		SelStn_2<-avgOccW_DSpells[,3+(selStn-1)*4]
		SelStn_3<-avgOccW_DSpells[,4+(selStn-1)*4]
		SelStn_4<-avgOccW_DSpells[,5+(selStn-1)*4]
		ymax_1<-max(SelStn_1)								
		ymin_1<-min(SelStn_1)
		yext_1<-(ymax_1-ymin_1)*0.05							 
		ymax_2<-max(SelStn_2)								
		ymin_2<-min(SelStn_2)
		yext_2<-(ymax_2-ymin_2)*0.05							 
		ymax_3<-max(SelStn_3)								
		ymin_3<-min(SelStn_3)
		yext_3<-(ymax_3-ymin_3)*0.05							 
		ymax_4<-max(SelStn_4)								
		ymin_4<-min(SelStn_4)
		yext_4<-(ymax_4-ymin_4)*0.05		
		par(mfrow = c(2,2),mar = c(2,2,1,0.5),oma=c(4,1,2,0.5),xpd=TRUE,pty="s")							 	 		 																	 
		boxplot(SelStn_1[2:(nSim+1)],ylim=c(ymin_1-yext_1,ymax_1+yext_1),
			 xaxt='n')
		mtext(side = 1, text = paste(text1), line = 0.5,cex=1)
		points(SelStn_1[1],col="red",pch=21,xaxt='n')
		boxplot(SelStn_2[2:(nSim+1)],ylim=c(ymin_2-yext_2,ymax_2+yext_2),
			 xaxt='n')
		mtext(side = 1, text = paste(text2), line = 0.5,cex=1)
		points(SelStn_2[1],col="red",pch=21,xaxt='n')							 							 
		boxplot(SelStn_3[2:(nSim+1)],ylim=c(ymin_3-yext_3,ymax_3+yext_3),
			 xaxt='n')		
        mtext(side = 1, text = paste(text3), line = 0.5,cex=1)									
		points(SelStn_3[1],col="red",pch=21,xaxt='n')	
        boxplot(SelStn_4[2:(nSim+1)],ylim=c(ymin_4-yext_4,ymax_4+yext_4),
			 xaxt='n')
		mtext(side = 1, text = paste(text4), line = 0.5,cex=1)
		points(SelStn_4[1],col="red",pch=21,xaxt='n')
		par(mfg=c(1,1))
		boxplot(mean(SelStn_1[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		boxplot(mean(SelStn_2[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(SelStn_3[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')
		boxplot(mean(SelStn_4[2:(nSim+1)]),border=2,lwd=0.5,yaxt='n')							 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main, "at station",rfStatSelStn),outer = T,cex.main=1) 							 
		legend("bottom", inset=c(-0.1,-0.1),legend = c("observed","simulations mean"),
			col=c("red","red"),lty=c(0,1),lwd=c(0,1),pch=c(21,NA),
			bg = "white", horiz=TRUE,cex=1,bty="n")		
	}
}
annualCrsCorrlPlotFun<-function(scanIndex1,scanIndex2,scanIndex3,main,nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth){
	#scanIndex1<-0, scanIndex2<-0, scanIndex3<-2, for daily log-odds ratio on seasonal and annual basis
	#scanIndex1<-1, scanIndex2<-0, scanIndex3<-1, for daily crs-corrl of rf-wet days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-1, scanIndex3<-1, for daily crs-corrl of rf-all days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-2, scanIndex3<-1, for cross-corrl of number wet days in season and year
	#scanIndex1<-1, scanIndex2<-3, scanIndex3<-1, for cross-corrl of seasonal & annual rainfall
	if (nStation>=2){
		seasonalAnuualStat<-matrix(scan(file=statFile,
		skip=11*(2+nSim)+3*(3+nSim)+scanIndex1*(2+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex2*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex3,
		nlines=(nStation-1)*nStation-sum(1:(nStation-1)),quiet = TRUE),
		nrow=(nStation-1)*nStation-sum(1:(nStation-1)),ncol=22,byrow=TRUE)
		Rep<-seasonalAnuualStat[,21]
		Ob<-seasonalAnuualStat[,19]
		qq<-qqplot(Ob,Rep, plot.it = FALSE)	
		par(pty="s")
		plot(qq$x,qq$y,xlim=1.05*range(qq$x,qq$y),ylim=1.05*range(qq$x,qq$y),
		xlab = "Observed",ylab = "Simulated",main=paste(main),lwd=linewidth,
		cex.main=fontsize,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit <- lm(Rep ~ Ob, data = qq)
		#abline(fit,lty=3,cex=1.2)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,lwd=linewidth,cex=fontsize)	
	}	
}
seasonalCrsCorrlPlotFun<-function(scanIndex1,scanIndex2,scanIndex3,main,nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth){
	#scanIndex1<-0, scanIndex2<-0, scanIndex3<-2, for daily log-odds ratio on seasonal and annual basis
	#scanIndex1<-1, scanIndex2<-0, scanIndex3<-1, for daily crs-corrl of rf-wet days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-1, scanIndex3<-1, for daily crs-corrl of rf-all days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-2, scanIndex3<-1, for cross-corrl of number wet days in season and year
	#scanIndex1<-1, scanIndex2<-3, scanIndex3<-1, for cross-corrl of seasonal & annual rainfall
	if (nStation>=2){
		seasonalAnuualStat<-matrix(scan(file=statFile,
						skip=11*(2+nSim)+3*(3+nSim)+scanIndex1*(2+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex2*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex3,nlines=(nStation-1)*nStation-sum(1:(nStation-1)),quiet = TRUE),
						nrow=(nStation-1)*nStation-sum(1:(nStation-1)),ncol=22,byrow=TRUE)
		Season_3Rep<-seasonalAnuualStat[,13]
		Season_4Rep<-seasonalAnuualStat[,17]
		Season_1Rep<-seasonalAnuualStat[,5]
		Season_2Rep<-seasonalAnuualStat[,9]
		Season_3Ob<-seasonalAnuualStat[,11]
		Season_4Ob<-seasonalAnuualStat[,15]
		Season_1Ob<-seasonalAnuualStat[,3]
		Season_2Ob<-seasonalAnuualStat[,7]							 	
		par(mfrow = c(2,2),mar = c(4,4,2,1),oma=c(1.5,1.5,3,1),xpd=FALSE,pty="s")	
		qq_au<-qqplot(Season_1Ob, Season_1Rep, plot.it = FALSE)
		plot(qq_au$x,qq_au$y,xlim=1.05*range(qq_au$x,qq_au$y),ylim=1.05*range(qq_au$x,qq_au$y),
			xlab="",ylab="",asp=1,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit_au <- lm(Season_1Rep ~ Season_1Ob, data = qq_au)
		#abline(fit_au,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)			 	 
		mtext(side = 3, text = "Season_1", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)
		qq_wi<-qqplot(Season_2Ob, Season_2Rep, plot.it = FALSE)
		plot(qq_wi$x,qq_wi$y,xlim=1.05*range(qq_wi$x,qq_wi$y),ylim=1.05*range(qq_wi$x,qq_wi$y),
			xlab="",ylab="",asp=1,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit_wi <- lm(Season_2Rep ~ Season_2Ob, data = qq_wi)
		#abline(fit_wi,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)	 	 
		mtext(side = 3, text = "Season_2", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
		qq_sp<-qqplot(Season_3Ob, Season_3Rep, plot.it = FALSE)
		plot(qq_sp$x,qq_sp$y,xlim=1.05*range(qq_sp$x,qq_sp$y),ylim=1.05*range(qq_sp$x,qq_sp$y),
			xlab="",ylab="",asp=1,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit_sp <- lm(Season_3Rep ~ Season_3Ob, data = qq_sp)
		#abline(fit_sp,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 	 
		mtext(side = 3, text = "Season_3", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)							 
		qq_su<-qqplot(Season_4Ob, Season_4Rep, plot.it = FALSE)
		plot(qq_su$x,qq_su$y,xlim=1.05*range(qq_su$x,qq_su$y),ylim=1.05*range(qq_su$x,qq_su$y),
			xlab="",ylab="",asp=1,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit_su <- lm(Season_4Rep ~ Season_4Ob, data = qq_su)
		#abline(fit_su,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)			 	 
		mtext(side = 3, text = "Season_4", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 3,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 3,cex=fontsize)						 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=fontsize+0.3) 
	}	
}
seasonalCrsCorrlSavePlotFun<-function(scanIndex1,scanIndex2,scanIndex3,main,nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth){
	#scanIndex1<-0, scanIndex2<-0, scanIndex3<-2, for daily log-odds ratio on seasonal and annual basis
	#scanIndex1<-1, scanIndex2<-0, scanIndex3<-1, for daily crs-corrl of rf-wet days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-1, scanIndex3<-1, for daily crs-corrl of rf-all days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-2, scanIndex3<-1, for cross-corrl of number wet days in season and year
	#scanIndex1<-1, scanIndex2<-3, scanIndex3<-1, for cross-corrl of seasonal & annual rainfall
	if (nStation>=2){
		seasonalAnuualStat<-matrix(scan(file=statFile,
						skip=11*(2+nSim)+3*(3+nSim)+scanIndex1*(2+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex2*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex3,nlines=(nStation-1)*nStation-sum(1:(nStation-1)),quiet = TRUE),
						nrow=(nStation-1)*nStation-sum(1:(nStation-1)),ncol=22,byrow=TRUE)
		Season_3Rep<-seasonalAnuualStat[,13]
		Season_4Rep<-seasonalAnuualStat[,17]
		Season_1Rep<-seasonalAnuualStat[,5]
		Season_2Rep<-seasonalAnuualStat[,9]
		Season_3Ob<-seasonalAnuualStat[,11]
		Season_4Ob<-seasonalAnuualStat[,15]
		Season_1Ob<-seasonalAnuualStat[,3]
		Season_2Ob<-seasonalAnuualStat[,7]							 	
		par(mfrow = c(2,2),mar = c(4,4,2,1),oma=c(1.5,1.5,3,1),xpd=FALSE,pty="s")	
		qq_au<-qqplot(Season_1Ob, Season_1Rep, plot.it = FALSE)
		plot(qq_au$x,qq_au$y,xlim=1.05*range(qq_au$x,qq_au$y),ylim=1.05*range(qq_au$x,qq_au$y),
			xlab="",ylab="",asp=1,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit_au <- lm(Season_1Rep ~ Season_1Ob, data = qq_au)
		#abline(fit_au,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)			 	 
		mtext(side = 3, text = "Season_1", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 2,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 2,cex=fontsize)
		qq_wi<-qqplot(Season_2Ob, Season_2Rep, plot.it = FALSE)
		plot(qq_wi$x,qq_wi$y,xlim=1.05*range(qq_wi$x,qq_wi$y),ylim=1.05*range(qq_wi$x,qq_wi$y),
			xlab="",ylab="",asp=1,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit_wi <- lm(Season_2Rep ~ Season_2Ob, data = qq_wi)
		#abline(fit_wi,lty=3)	
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)	 	 
		mtext(side = 3, text = "Season_2", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 2,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 2,cex=fontsize)							 
		qq_sp<-qqplot(Season_3Ob, Season_3Rep, plot.it = FALSE)
		plot(qq_sp$x,qq_sp$y,xlim=1.05*range(qq_sp$x,qq_sp$y),ylim=1.05*range(qq_sp$x,qq_sp$y),
			xlab="",ylab="",asp=1,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit_sp <- lm(Season_3Rep ~ Season_3Ob, data = qq_sp)
		#abline(fit_sp,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)		 	 
		mtext(side = 3, text = "Season_3", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 2,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 2,cex=fontsize)							 
		qq_su<-qqplot(Season_4Ob, Season_4Rep, plot.it = FALSE)
		plot(qq_su$x,qq_su$y,xlim=1.05*range(qq_su$x,qq_su$y),ylim=1.05*range(qq_su$x,qq_su$y),
			xlab="",ylab="",asp=1,cex.lab=fontsize, cex.axis=fontsize,cex=fontsize)
		#fit_su <- lm(Season_4Rep ~ Season_4Ob, data = qq_su)
		#abline(fit_su,lty=3)
		#Add a diagonal line to the scatter plot
		lines(par()$usr[1:2],par()$usr[3:4],lty=3,cex=fontsize,lwd=linewidth)			 	 
		mtext(side = 3, text = "Season_4", line = 0.5,cex=fontsize)
		mtext(side = 1, text = "Observed", line = 2,cex=fontsize)
		mtext(side = 2, text = "Simulated", line = 2,cex=fontsize)						 
		par(mfrow = c(1,1),mar = c(0,0,0,0),oma=c(0,0,2,0),xpd=TRUE)
		title(main=paste(main),outer = T,cex.main=fontsize+0.3) 
	}	
}

#DataFrame functions
annualStatDfFun<-function(annualStat,nSim,nStation,rfStatSelStn,stnNumber,stnName){
	if (rfStatSelStn=="All stations"){
		if (nStation==1){
			ColIndex<-6
			Rep<-annualStat[2:(nSim+1),ColIndex]
		}
		if (nStation>=2){
			ColIndex<-seq(from=6,to=1+nStation*5,by=5)   
			Rep<-apply(annualStat[2:(nSim+1),ColIndex],2,mean)
		}
		Ob<-annualStat[1,ColIndex]#length=30
		annualStat.df<-data.frame(as.numeric(stnNumber),as.vector(as.matrix(stnName)),
			as.numeric(format(round(Ob,digits=1),nsmall=1)),
			as.numeric(format(round(Rep,digits=1),nsmall=1)))
		colnames(annualStat.df)<-c("Station Number","Station Name","Observed","Mean")		 
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
	    annualStatSelStn<-annualStat[,1+selStn*5]
	    quantiles<-as.numeric(format(round(quantile(annualStatSelStn[2:(nSim+1)],c(0.05,0.25,0.5,0.75,0.95)),digits=1),nsmall=1))
		annualStat.df<-data.frame(selStnNumber,as.vector(as.matrix(stnName))[selStn],
			as.numeric(format(round(annualStatSelStn[1],digits=1),nsmall=1)),
			as.numeric(format(round(mean(annualStatSelStn[2:(nSim+1)]),digits=1),nsmall=1)),quantiles[1],
			quantiles[2],quantiles[3],quantiles[4],quantiles[5])
		colnames(annualStat.df)<-c("Station Number","Station Name","Observed",
			"Mean Simulated","5%th Simulated","25%th Simulated",
			"50%th Simulated","75%th Simulated","95%th Simulated")						
	}
	return(annualStat.df)
}
seasonalStatDfFun<-function(seasonalStat,nSim,nStation,rfStatSelStn,stnNumber,stnName){
	if (rfStatSelStn=="All stations"){
		if (nStation==1){
			AnnualColIndex<-6
			#seasonal repl. and seasonal ob.
			Rep<-seasonalStat[2:(nSim+1),c(-1,-AnnualColIndex)]
		}
		if (nStation>=2){
			AnnualColIndex<-seq(from=6,to=1+nStation*5,by=5)
			#seasonal repl. and seasonal ob.
			Rep<-apply(seasonalStat[2:(nSim+1),c(-1,-AnnualColIndex)],2,mean)
		}

		Ob<-seasonalStat[1,c(-1,-AnnualColIndex)]						 					 
		seasonalStat.df<-data.frame(rep(as.numeric(stnNumber),each=4),rep(as.vector(as.matrix(stnName)),each=4),
		  	rep(c("Season_1","Season_2","Season_3","Season_4"),nStation),as.numeric(format(round(Ob,1),nsmall=1)),
			as.numeric(format(round(Rep,1),nsmall=1)))
		colnames(seasonalStat.df)<-c("Station Number","Station Name","Season","Observed","Mean Simulated")			 
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		seasonalStatSelStn<-seasonalStat[,(2+(selStn-1)*5):(5+(selStn-1)*5)]
		seasonalQuantiles<-format(round(apply(seasonalStatSelStn,2,function(x) quantile(x[2:(nSim+1)],c(0.05,0.25,0.5,0.75,0.95))),1),nsmall=1)
		seasonalStat.df<-data.frame(rep(selStnNumber,each=4),rep(as.vector(as.matrix(stnName))[selStn],each=4),
			c("Season_1","Season_2","Season_3","Season_4"),
			as.numeric(format(round(seasonalStatSelStn[1,],1),nsmall=1)),
			as.numeric(format(round(apply(seasonalStatSelStn[2:(nSim+1),],2,mean),1),nsmall=1)),
			as.numeric(seasonalQuantiles[1,]),as.numeric(seasonalQuantiles[2,]),
			as.numeric(seasonalQuantiles[3,]),as.numeric(seasonalQuantiles[4,]),
			as.numeric(seasonalQuantiles[5,]))             																																																																							
		colnames(seasonalStat.df)<-c("Station Number","Station Name","Season",
			"Observed","Mean Simulated","5%th Simulated","25%th Simulated",
			"50%th Simulated","75%th Simulated","95%th Simulated")						
	}
	return(seasonalStat.df)
}
monthlyStatDfFun<-function(monthlyStat,nSim,nStation,rfStatSelStn,stnNumber,stnName){	 
	if (rfStatSelStn=="All stations"){
        Ob<-monthlyStat[1,]
		stn_Ob<-Ob[2:13]#Grab data in Station 1
		Rep<-apply(monthlyStat[2:(nSim+1),],2,mean)#mean of all simulations
		stn_Rep<-Rep[2:13]#Grab data in Station 1	
		if (nStation>=2){	
			for (iStn in 2:nStation){
				istn_Ob<-Ob[(2+(iStn-1)*12):(13+(iStn-1)*12)]
				istn_Rep<-Rep[(2+(iStn-1)*12):(13+(iStn-1)*12)]
				stn_Rep<-rbind(stn_Rep,istn_Rep) # First row has Rep from Jan to Dec for Station 1
				stn_Ob<-rbind(stn_Ob,istn_Ob)
			}
		}
		stn_Rep<-as.vector(t(stn_Rep))
		stn_Ob<-as.vector(t(stn_Ob))
	    monthlyStat.df<-data.frame(rep(as.numeric(stnNumber),each=12),
			rep(as.vector(as.matrix(stnName)),each=12),rep(month.abb,nStation),
			as.numeric(format(round(stn_Ob,1),nsmall=1)),
			as.numeric(format(round(stn_Rep,1),nsmall=1)))
		colnames(monthlyStat.df)<-c("Station Number","Station Name","Month","Observed","Mean Simulated")							 
	}						
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
        monthlyStatSelStn<-monthlyStat[,(2+(selStn-1)*12):(13+(selStn-1)*12)]						 
	    monthlyQuantiles<-format(round(apply(monthlyStatSelStn,2,
			function(x) quantile(x[2:(nSim+1)],c(0.05,0.25,0.5,0.75,0.95))),1),nsmall=1)
  	    monthlyStat.df<-data.frame(rep(selStnNumber,each=12),
		rep(as.vector(as.matrix(stnName))[selStn],each=12),month.abb,
		as.numeric(format(round(monthlyStatSelStn[1,],1),nsmall=1)),
		as.numeric(format(round(apply(monthlyStatSelStn[2:(nSim+1),],2,mean),1),nsmall=1)),
		as.numeric(monthlyQuantiles[1,]),as.numeric(monthlyQuantiles[2,]),
		as.numeric(monthlyQuantiles[3,]),as.numeric(monthlyQuantiles[4,]),
		as.numeric(monthlyQuantiles[5,]))
		colnames(monthlyStat.df)<-c("Station Number","Station Name","Month","Observed","Mean Simulated",
			"5%th Simulated","25%th Simulated","50%th Simulated","75%th Simulated","95%th Simulated")		 			 
	}
	return(monthlyStat.df)
}			
maxSpelllength5thRfAmtDfFun<-function(maxSpelllength5thRfAmt,fromCol,nSim,nStation,rfStatSelStn,stnNumber,stnName){					 
	if (rfStatSelStn=="All stations"){
		ColIndex<-seq(from=fromCol,to=1+nStation*3,by=3)
		Rep<-apply(maxSpelllength5thRfAmt[2:(nSim+1),ColIndex],2,mean)	
		Ob<-maxSpelllength5thRfAmt[1,ColIndex]								 
		maxSpelllength5thRfAmt.df<-data.frame(as.numeric(stnNumber),
			as.vector(as.matrix(stnName)),as.numeric(format(round(Ob,1),nsmall=1)),
			as.numeric(format(round(Rep,1),nsmall=1)))
		colnames(maxSpelllength5thRfAmt.df)<-c("Station Number","Station Name","Observed","Mean Simulated")		 										 							 
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
        maxSpelllength5thRfAmtSelStn<-maxSpelllength5thRfAmt[,fromCol+(selStn-1)*3]
	    quantiles<-as.numeric(format(round(quantile(maxSpelllength5thRfAmtSelStn[2:(nSim+1)],c(0.05,0.25,0.5,0.75,0.95)),1),nsmall=1))
		maxSpelllength5thRfAmt.df<-data.frame(selStnNumber,as.vector(as.matrix(stnName))[selStn],
			as.numeric(format(round(maxSpelllength5thRfAmtSelStn[1],1),nsmall=1)),
			as.numeric(format(round(mean(maxSpelllength5thRfAmtSelStn[2:(nSim+1)]),1),nsmall=1)),
			quantiles[1],quantiles[2],quantiles[3],quantiles[4],quantiles[5])
		colnames(maxSpelllength5thRfAmt.df)<-c("Station Number","Station Name",
			"Observed","Mean Simulated","5%th Simulated","25%th Simulated",
			"50%th Simulated","75%th Simulated","95%th Simulated")						 					
	}
    return(maxSpelllength5thRfAmt.df)		
}
totRfAmtInWSDfFun<-function(totRfAmtInWS,text1,text2,text3,text4,text5,nSim,nStation,rfStatSelStn,stnNumber,stnName){
	#text1="1-day",text2="2-4 days", text3="5-7 days",text4="> 7 days", text5="Wet Spell Length"		
	Rep<-apply(totRfAmtInWS[2:(nSim+1),2:(1+4*nStation)],2,mean)
	Ob<-totRfAmtInWS[1,2:(1+4*nStation)]										
	if (rfStatSelStn=="All stations"){
		totRfAmtInWS.df<-data.frame(rep(as.numeric(stnNumber),each=4),rep(as.vector(as.matrix(stnName)),each=4),
			rep(c(paste(text1),paste(text2),paste(text3),paste(text4)),nStation),
			as.numeric(format(round(Ob,1),nsmall=1)),as.numeric(format(round(Rep,1),nsmall=1)))	
		colnames(totRfAmtInWS.df)<-c("Station Number","Station Name",paste(text5),"Observed","Mean Simulated")
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
		SelStn_1<-totRfAmtInWS[,2+(selStn-1)*4]
		SelStn_2<-totRfAmtInWS[,3+(selStn-1)*4]
		SelStn_3<-totRfAmtInWS[,4+(selStn-1)*4]
		SelStn_4<-totRfAmtInWS[,5+(selStn-1)*4]				         
		selStnNumber<-as.numeric(rfStatSelStn)
        totRfAmtInWSSelStn<-totRfAmtInWS[,2:(1+4*nStation)]						 
		totRfAmtInWSQuantiles<-format(round(apply(totRfAmtInWSSelStn,2,
			function(x) quantile(x[2:(nSim+1)],c(0.05,0.25,0.5,0.75,0.95))),1),nsmall=1)
  	    totRfAmtInWS.df<-data.frame(rep(selStnNumber,each=4),
			rep(as.vector(as.matrix(stnName))[selStn],each=4),
			c(paste(text1),paste(text2),paste(text3),paste(text4)),
			as.numeric(format(round(totRfAmtInWSSelStn[1,],1),nsmall=1)),
			as.numeric(format(round(apply(totRfAmtInWSSelStn[2:(nSim+1),],2,mean),1),nsmall=1)),
			as.numeric(totRfAmtInWSQuantiles[1,]),as.numeric(totRfAmtInWSQuantiles[2,]),
			as.numeric(totRfAmtInWSQuantiles[3,]),as.numeric(totRfAmtInWSQuantiles[4,]),
			as.numeric(totRfAmtInWSQuantiles[5,]))
		colnames(totRfAmtInWS.df)<-c("Station Number","Station Name",paste(text5),
			"Observed","Mean Simulated","5%th Simulated","25%th Simulated",
			"50%th Simulated","75%th Simulated","95%th Simulated")
    }
	return(totRfAmtInWS.df)	
}
rfStatInAYearDfFun<-function(scanIndex1,scanIndex2,scanIndex3,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName){ 
	#scanIndex1<-1,scanIndex2<-0,scanIndex3<-2 for number of wet days in a year
	#scanIndex1<-3,scanIndex2<-0,scanIndex3<-2 for maximum wet spell length in a year
	#scanIndex1<-5,scanIndex2<-0,scanIndex3<-1 for maximum dry spell length in a year
	#scanIndex1<-4,scanIndex2<-0,scanIndex3<-2 for average numer of wet spells>1 in a year
	#scanIndex1<-5,scanIndex1<-0,scanIndex3<-1 for average number of dry spells >1 in a year
	#scanIndex1<-0,scanIndex2<-0,scanIndex3<-2 for maxm rf amt in a year
	#scanIndex1<-2,scanIndex2<-0,scanIndex3<-2 for avg rf amt in a year
	if (rfStatSelStn=="All stations"){
		iStn<-1
		if (nYrStat %% 2 ==0){
			med_RfStat<-apply(matrix(scan(file=statFile,
				skip=(iStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3+(nYrStat/2-1),nlines=2,quiet = TRUE),
				nrow=2,ncol=8,byrow=TRUE),2,median)}
		else{
			med_RfStat<-matrix(scan(file=statFile,
				skip=(iStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3+(nYrStat-1)/2,nlines=1,quiet = TRUE),
				nrow=1,ncol=8,byrow=TRUE)}		
		if (nStation>=2){
			for (iStn in 2:nStation){ 
				if (nYrStat %% 2 ==0){
					imed_RfStat<-apply(matrix(scan(file=statFile,
						skip=(iStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3+(nYrStat/2-1),nlines=2,quiet = TRUE),
						nrow=2,ncol=8,byrow=TRUE),2,median)
				}
				else{
					imed_RfStat<-matrix(scan(file=statFile,
						skip=(iStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3+(nYrStat-1)/2,nlines=1,quiet = TRUE),
						nrow=1,ncol=8,byrow=TRUE)
				}			
				med_RfStat<-rbind(med_RfStat,imed_RfStat)						
			}
		}
						
		med_RfStatRep<-med_RfStat[,7]
		med_RfStatOb<-med_RfStat[,5]					
		rfStatInAYear.df<-data.frame(as.numeric(stnNumber),as.vector(as.matrix(stnName)),
								  as.numeric(format(round(med_RfStatOb,1),nsmall=1)),
								  as.numeric(format(round(med_RfStatRep,1),nsmall=1)))
		colnames(rfStatInAYear.df)<-c("Station Number","Station Name","Median Observed","Median simulations")
	}
	else{ 
		selStnNumber<-as.numeric(rfStatSelStn) 
		selStn<-which(stnNumber==selStnNumber)
		if (nStation==1){
			rfStatInAYearSelStn<-matrix(scan(file=statFile,
				skip=(selStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+2+4*1+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3,nlines=nYrStat,quiet = TRUE),
				nrow=nYrStat,ncol=8,byrow=TRUE)
		}
		if (nStation>=2){
			rfStatInAYearSelStn<-matrix(scan(file=statFile,
				skip=(selStn-1)*(5*(nYrStat+2)+2*(nYrStat+1))+11*(nSim+2)+3*(nSim+3)+(2+(nStation-1)*nStation-sum(1:(nStation-1)))+4*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex1*(nYrStat+2)+scanIndex2*(nYrStat+1)+scanIndex3,nlines=nYrStat,quiet = TRUE),
				nrow=nYrStat,ncol=8,byrow=TRUE)
		}
		rfStatInAYear.df<-data.frame(rep(selStnNumber,each=nYrStat),rep(as.vector(as.matrix(stnName))[selStn],each=nYrStat),
								  as.numeric(format(round(rfStatInAYearSelStn[,3],2),nsmall=2)),
								  as.numeric(format(round(rfStatInAYearSelStn[,5],1),nsmall=1)),
								  as.numeric(format(round(rfStatInAYearSelStn[,6],1),nsmall=1)),
								  as.numeric(format(round(rfStatInAYearSelStn[,7],1),nsmall=1)),
								  as.numeric(format(round(rfStatInAYearSelStn[,8],1),nsmall=1)))
		colnames(rfStatInAYear.df)<-c("Station Number","Station Name","Cumulative Probability","Observed","5%th Simulated",
										"50%th Simulated","95%th Simulated")											
	}
	return(rfStatInAYear.df)
}				
#text1="1-day",text2="2-4 days", text3="5-7 days",text4="> 7 days", text5="Wet Spell length"
avgOccW_DSpellsDfFun<-function(avgOccW_DSpells,text1,text2,text3,text4,text5,nSim,nStation,rfStatSelStn,stnNumber,stnName){
	 Rep<-apply(avgOccW_DSpells[2:(nSim+1),2:(1+4*nStation)],2,mean)
	 Ob<-avgOccW_DSpells[1,2:(1+4*nStation)]										
	 if (rfStatSelStn=="All stations"){
		avgOccW_DSpells.df<-data.frame(rep(as.numeric(stnNumber),each=4),
			rep(as.vector(as.matrix(stnName)),each=4),
			rep(c(paste(text1),paste(text2),paste(text3),paste(text4)),nStation),
			as.numeric(format(round(Ob,1),nsmall=1)),as.numeric(format(round(Rep,1),nsmall=1)))	
		colnames(avgOccW_DSpells.df)<-c("Station Number","Station Name",paste(text5),"Observed","Mean Simulated")				 							
	}
    else{ 		         
		selStnNumber<-as.numeric(rfStatSelStn)
		selStn<-which(stnNumber==selStnNumber)
	    avgOccW_DSpellsSelStn<-avgOccW_DSpells[,2:(1+4*nStation)]						 
	    avgOccW_DSpellsQuantiles<-format(round(apply(avgOccW_DSpellsSelStn,2,
			function(x) quantile(x[2:(nSim+1)],c(0.05,0.25,0.5,0.75,0.95))),1),nsmall=1)
  	    avgOccW_DSpells.df<-data.frame(rep(selStnNumber,each=4),
			rep(as.vector(as.matrix(stnName))[selStn],each=4),
			c(paste(text1),paste(text2),paste(text3),paste(text4)),
			as.numeric(format(round(avgOccW_DSpellsSelStn[1,],1),nsmall=1)),
			as.numeric(format(round(apply(avgOccW_DSpellsSelStn[2:(nSim+1),],2,mean),1),nsmall=1)),
			as.numeric(avgOccW_DSpellsQuantiles[1,]),as.numeric(avgOccW_DSpellsQuantiles[2,]),
			as.numeric(avgOccW_DSpellsQuantiles[3,]),as.numeric(avgOccW_DSpellsQuantiles[4,]),
			as.numeric(avgOccW_DSpellsQuantiles[5,]))
		colnames(avgOccW_DSpells.df)<-c("Station Number","Station Name",paste(text5),
			"Observed","Mean Simulated","5%th Simulated","25%th Simulated",
			"50%th Simulated","75%th Simulated","95%th Simulated")				 		
		}
	 return(avgOccW_DSpells.df)
	}				 	
annualCrsCorrlDfFun<-function(scanIndex1,scanIndex2,scanIndex3,nSim,nStation,statFile,nYrStat,stnNumber,stnName){
	#scanIndex1<-0, scanIndex2<-0, scanIndex3<-2, for daily log-odds ratio on seasonal and annual basis
	#scanIndex1<-1, scanIndex2<-0, scanIndex3<-1, for daily crs-corrl of rf-wet days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-1, scanIndex3<-1, for daily crs-corrl of rf-all days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-2, scanIndex3<-1, for cross-corrl of number wet days in season and year
	#scanIndex1<-1, scanIndex2<-3, scanIndex3<-1, for cross-corrl of seasonal & annual rainfall
	if (nStation>=2){
		seasonalAnuualStat<-matrix(scan(file=statFile,
		skip=11*(2+nSim)+3*(3+nSim)+scanIndex1*(2+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex2*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex3,nlines=(nStation-1)*nStation-sum(1:(nStation-1)),quiet = TRUE),
		nrow=(nStation-1)*nStation-sum(1:(nStation-1)),ncol=22,byrow=TRUE)		
		Rep5<-seasonalAnuualStat[,20]
		Rep50<-seasonalAnuualStat[,21]
		Rep95<-seasonalAnuualStat[,22]
		Ob<-seasonalAnuualStat[,19]
		stnIndex1<-seasonalAnuualStat[,1]
		stnIndex2<-seasonalAnuualStat[,2]
		stnNumber1<-as.numeric(stnNumber)[stnIndex1]
		stnNumber2<-as.numeric(stnNumber)[stnIndex2]
		stnName1<-as.vector(as.matrix(stnName))[stnIndex1]
		stnName2<-as.vector(as.matrix(stnName))[stnIndex2]
		annualStat.df<-data.frame(stnNumber1,stnName1,stnNumber2,stnName2,
			as.numeric(format(round(Ob,digits=2),nsmall=2)),
			as.numeric(format(round(Rep5,digits=2),nsmall=2)),
			as.numeric(format(round(Rep50,digits=2),nsmall=2)),
			as.numeric(format(round(Rep95,digits=2),nsmall=2)))
		colnames(annualStat.df)<-c("Station Number (1)","Station Name (1)",
			"Station Number (2)","Station Name 2","Observed","5%th Simulated",
			"50%th Simulated","95%th Simulated")	
		return(annualStat.df)
	}	
}
seasonalCrsCorrlDfFun<-function(scanIndex1,scanIndex2,scanIndex3,nSim,nStation,statFile,nYrStat,stnNumber,stnName){
	#scanIndex1<-0, scanIndex2<-0, scanIndex3<-2, for daily log-odds ratio on seasonal and annual basis
	#scanIndex1<-1, scanIndex2<-0, scanIndex3<-1, for daily crs-corrl of rf-wet days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-1, scanIndex3<-1, for daily crs-corrl of rf-all days on seas & annual basis
	#scanIndex1<-1, scanIndex2<-2, scanIndex3<-1, for cross-corrl of number wet days in season and year
	#scanIndex1<-1, scanIndex2<-3, scanIndex3<-1, for cross-corrl of seasonal & annual rainfall
	if (nStation>=2){
		seasonalAnuualStat<-matrix(scan(file=statFile,
			skip=11*(2+nSim)+3*(3+nSim)+scanIndex1*(2+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex2*(1+(nStation-1)*nStation-sum(1:(nStation-1)))+scanIndex3,nlines=(nStation-1)*nStation-sum(1:(nStation-1)),quiet = TRUE),
			nrow=(nStation-1)*nStation-sum(1:(nStation-1)),ncol=22,byrow=TRUE)
		seasonalRep5<-as.vector(as.matrix(seasonalAnuualStat[,c(4,8,12,16)],nrow=1,ncol=4*((nStation-1)*nStation-sum(1:(nStation-1))),byrow=TRUE))
		seasonalRep50<-as.vector(as.matrix(seasonalAnuualStat[,c(5,9,13,17)],nrow=1,ncol=4*((nStation-1)*nStation-sum(1:(nStation-1))),byrow=TRUE))
		seasonalRep95<-as.vector(as.matrix(seasonalAnuualStat[,c(6,10,14,18)],nrow=1,ncol=4*((nStation-1)*nStation-sum(1:(nStation-1))),byrow=TRUE))
		seasonalOb<-as.vector(as.matrix(seasonalAnuualStat[,c(3,7,11,15)],nrow=1,ncol=4*((nStation-1)*nStation-sum(1:(nStation-1))),byrow=TRUE))
		stnIndex1<-seasonalAnuualStat[,1]
		stnIndex2<-seasonalAnuualStat[,2]
		stnNumber1<-as.numeric(stnNumber)[stnIndex1]
		stnNumber2<-as.numeric(stnNumber)[stnIndex2]
		stnName1<-as.vector(as.matrix(stnName))[stnIndex1]
		stnName2<-as.vector(as.matrix(stnName))[stnIndex2]
		seasonalStat.df<-data.frame(rep(stnNumber1,each=4),rep(stnName1,each=4),
			rep(stnNumber2,each=4),rep(stnName2,each=4),
			rep(c("Season_1","Season_2","Season_3","Season_4"),(nStation-1)*nStation-sum(1:(nStation-1))),
			as.numeric(format(round(seasonalOb,2),nsmall=2)),
			as.numeric(format(round(seasonalRep5,2),nsmall=2)),
			as.numeric(format(round(seasonalRep50,2),nsmall=2)),
			as.numeric(format(round(seasonalRep95,2),nsmall=2)))               																																																																							
		colnames(seasonalStat.df)<-c("Station Number (1)","Station Name (1)",
			"Station Number (2)","Station Name 2","Season"," Observed",
			"5%th Simulated","50%th Simulated","95%th Simulated")
		return(seasonalStat.df)	
	}		
}

#Rainfall Occurrence page
#Function to read parameters from the "data.dat"	
rfOccTable<-gtkTable(rows=3,columns=4,homogeneous=FALSE)
notebookStat$appendPage(rfOccTable,gtkLabel("Rainfall Occurrence "))
rfOccOptionFrame<-gtkFrame("Rainfall Occurrence")
rfOccTable$attach(rfOccOptionFrame,left.attach=0,1,top.attach=0,1,
	xoptions=c("shrink","fill"),yoptions="",ypadding=0)
rfOccAnnualList<-c("mean of wet days","SD of wet days","maximum wet spell length",
	"maximum dry spell length","average Occurrence of wet spells of varying length",
	"average Occurrence of dry spells of varying length","number of wet days in a year",
	"maximum wet spell length in a year","average number of wet spell>1 in a year",
	"maximum dry spell length in a year","average number of dry spell>1 in a year",
	"daily log-odds ratio","cross-correlation of number of wet days")
rfOccSeasonalList<-c("mean of wet days","SD of wet days","daily log-odds ratio",
	"cross-correlation of number of wet days")	
rfOccMonthlyList<-c("mean of wet days","SD of wet days")
rfOccOption<-data.frame(aggregation=c(rep("Annual",length(rfOccAnnualList)),
	rep("Seasonal",length(rfOccSeasonalList)),rep("Monthly",length(rfOccMonthlyList))),
	rfOccStat=c(rfOccAnnualList,rfOccSeasonalList,rfOccMonthlyList))
rfOccOptionModel<-gtkTreeStore("gchararray")
by (rfOccOption,rfOccOption$aggregation,function(DF2){
	parent_iter <- rfOccOptionModel$append()
	rfOccOptionModel$setValue(parent_iter$iter,column = 0,value = DF2$aggregation)
	sapply ( DF2$rfOccStat, function (rfOccStat){
		child_iter <- rfOccOptionModel$append(parent = parent_iter$iter)
		if (is.null(child_iter$retval))
		rfOccOptionModel$setValue(child_iter$iter,column = 0 ,value = rfOccStat)
	})
})
rfOccOptionView<-gtkTreeView()
rfOccOptionView$getSelection()$setMode("browse")
rfOccOptionView$insertColumnWithAttributes(0,"              ",gtkCellRendererText(),text=0)
rfOccOptionView$setModel(rfOccOptionModel)
rfOccScrolledWindow<-gtkScrolledWindow()
rfOccScrolledWindow$setSizeRequest(200,600)
rfOccScrolledWindow$add(rfOccOptionView)
rfOccOptionFrame$add(rfOccScrolledWindow)
rfOccStnSelFrame<-gtkFrame("Select Station: ")
rfOccTable$attach(rfOccStnSelFrame,left.attach=0,1,top.attach=1,2,
	xoptions=c("shrink","fill"),yoptions="",ypadding=0)
rfOccStnCombo <- gtkComboBoxNewText()
rfOccStnSelFrame$add(rfOccStnCombo)
gSignalConnect(rfOccStnCombo,"changed",f = function(button,...){    
	#message("",button$getActiveText(),"\n")
	list<-readLines("statistics_view_option.dat")
	isuccess=as.numeric(list[2])
	if(isuccess==1) {rfOccOptionFun()}
})
rfOccViewOptionFrame<-gtkFrame("View Options")
rfOccTable$attach(rfOccViewOptionFrame,left.attach=1,2,top.attach=1,2,
	xoptions=c("expand","fill"),yoptions="",ypadding=0)
rfOccViewOptionLabels<-c("Grid","Plot")
rfOccViewOptionRadioGp<-list() 
rfOccViewOptionRadioGp [[rfOccViewOptionLabels[1]]]<-gtkRadioButton(label=rfOccViewOptionLabels[1])
for(label in rfOccViewOptionLabels [-1])
rfOccViewOptionRadioGp[[label]]<-gtkRadioButton(rfOccViewOptionRadioGp,label=label)
rfOccViewOptionHBox<-gtkHBox(homogeneous = NULL,spacing = NULL,show = TRUE)
rfOccViewOptionFrame$add(rfOccViewOptionHBox)
sapply(rfOccViewOptionRadioGp,gtkBoxPackStart,object=rfOccViewOptionHBox)
rfOccViewOptionHBox[[2]]$setActive(TRUE)
sapply(rfOccViewOptionRadioGp,'[',"active")
sapply(rfOccViewOptionRadioGp,gSignalConnect,"toggled",
	function(button,data){
		if(button['active']){
			#message("",button$getLabel(),"\n")
			list<-readLines("statistics_view_option.dat")
			isuccess=as.numeric(list[2])
			if (isuccess==1) {rfOccOptionFun()}
		}
	})	
rfOccSaveViewButton<-gtkButtonNewWithLabel("Save View")
rfOccTable$attach(rfOccSaveViewButton,left.attach=0,1,top.attach=2,3,
	xoptions=c("shrink","fill"),yoptions="",ypadding=0)	
#add plot device to rfOCCTable
rfOccPlotDeviceAdd<-function(){				 				
	rfOccPlotDevice<-gtkDrawingArea()
	rfOccPlotDevice$setSizeRequest(600,600)
	asCairoDevice(rfOccPlotDevice)
	rfOccTable$attach(rfOccPlotDevice,left.attach=1,2,top.attach=0,1,
		xoptions=c("expand","fill"),yoptions="",ypadding=0)
	Sys.sleep(.1)
}

#Function to view rainfall occurrence statistics
rfOccOptionFun<-function(){
	 if (length(dev.list())>1) dev.off()
	 if(length(rfOccOptionSel$getSelectedRows()$retval)==1){ 		 
		statFile<-"stat.out"
		#Read user-defined parameters
		parameters<-scan(file="data.dat",skip=2,nline=1,quiet = TRUE)
		nYr<-parameters[1]
		yrStart<-parameters[2]
		band<-parameters[3]
		nStation<-parameters[4]
		nSim<-parameters[5]
		nYrSim<-parameters[8]
		nYrStat<-max(parameters[8],parameters[1]) #multi_site_rain.f L4643
		# Modified on 26 May 2017
		seasonIdx<-read.table("data.dat", header =FALSE, sep = "\t", nrows =1,skip = 8,strip.white = FALSE)
		seasonIdx1<-as.numeric(seasonIdx[1])
		seasonIdx2<-as.numeric(seasonIdx[2])
		seasonIdx3<-as.numeric(seasonIdx[3])
		seasonIdx4<-as.numeric(seasonIdx[4])
		seasonIdx5<-as.numeric(seasonIdx[5])
		seasonIdx6<-as.numeric(seasonIdx[6])
		seasonIdx7<-as.numeric(seasonIdx[7])
		seasonIdx8<-as.numeric(seasonIdx[8])
		seasonIdx9<-as.numeric(seasonIdx[9])
		seasonIdx10<-as.numeric(seasonIdx[10])
		seasonIdx11<-as.numeric(seasonIdx[11])
		seasonIdx12<-as.numeric(seasonIdx[12])
		
		
		inputDataFile<-FileLabel$getText()
		stnNumber<-read.table(inputDataFile,nrows=1)[2:(nStation+1)]	
	    stnName<-read.table(inputDataFile,skip=1,nrow=1,quote="\"")[2:(nStation+1)]
		#get view option from radiobutton gp
		sapply(rfOccViewOptionRadioGp,function(button,data){
			if(button['active']){
				list<-readLines("statistics_view_option.dat")
				list<-sub(list[4],button$getLabel(),list)
				writeLines(list,"statistics_view_option.dat") 
			}
		}) 
		list<-readLines("statistics_view_option.dat")
		rfOccViewOption<-list[4]
		rfStatSelStn<-rfOccStnCombo$getActiveText()
		#rfOccPlotDeviceAdd()				        				 				 														 																							
		if(length(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices())==2){
			if (rfOccViewOption=="Plot"){
				rfOccPlotDeviceAdd()
				#Mean of annual wet days plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,0))){
					wetDaysAnnualSeasonalMean<-matrix(scan(file=statFile,skip=0*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					fontsize<-1.5
					linewidth<-2
					mainLength<-nchar("Mean of annual wet days")
					annualStatPlotFun(wetDaysAnnualSeasonalMean,"Mean of annual wet days",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)					 					
				}
				#SD of annual wet days plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,1))){
					wetDaysAnnualSeasonalSD<-matrix(scan(file=statFile,skip=3*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)					 
					fontsize<-1.5
					linewidth<-2
					mainLength<-nchar("SD of annual wet days")
					annualStatPlotFun(wetDaysAnnualSeasonalSD,"SD of annual wet days",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)						
				}	
				#Maximum wet spell lengths plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,2))){
					rfOccMaxSpell5th<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)
					fontsize<-1.5
					linewidth<-2
					mainLength<-nchar("Maximum wet spell length")
					maxSpelllength5thRfAmtPlotFun(rfOccMaxSpell5th,2,"Maximum wet spell length",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)	
				}
				#Maximum dry spell lengths plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,3))){
					rfOccMaxSpell5th<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)						 						 
					fontsize<-1.5
					linewidth<-2
					mainLength<-nchar("Maximum dry spell length")
					maxSpelllength5thRfAmtPlotFun(rfOccMaxSpell5th,3,"Maximum dry spell length",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)	
					skip<-10*(nSim+2)+1
				}
				#Average Occurrence of wet spells of varying lengths plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,4))){ 
					avgOccOfWS<-matrix(scan(file=statFile,skip=11*(nSim+2)+0*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
					fontsize<-1.2
					linewidth<-1
					avgOccW_DSpellsPlotFun(avgOccOfWS,"1-day","2-4 days","5-7 days","> 7 days",
						c("Average occurrence of wet spells","\nof varying lengths"),nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth)
				}	
				 #Average Occurrence of dry spells of varying lengths plot
				 if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,5))){
					avgOccOfDS<-matrix(scan(file=statFile,skip=11*(nSim+2)+2*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)	
					fontsize<-1.2
					linewidth<-1
					avgOccW_DSpellsPlotFun(avgOccOfDS,"1-day","2-9 days","9-18 days","> 18 days",
						c("Average occurrence of dry spells","\nof varying lengths"),nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth)
				}	
				 #Number of wet days in a year plot
				 if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,6))){
					#scanIndex1<-1,scanIndex2<-0,scanIndex3<-2 for number of wet days in a year
					fontsize<-1.5
					linewidth<-2
					mainLength<-nchar("Number of wet days in a year")
					rfStatInAYearPlotFun(1,0,2,"Number of wet days in a year",nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)
				}	
				#Maximum wet spell length in a year plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,7))){
					#scanIndex1<-3,scanIndex2<-0,scanIndex3<-2 for maximum wet spell length in a year 
					fontsize<-1.5
					linewidth<-2
					mainLength<-nchar("Maximum wet spell length in a year")
					rfStatInAYearPlotFun(3,0,2,"Maximum wet spell length in a year",nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)							 
				}	
				#Average number of wet spells > 1 in a year plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,8))){
					#scanIndex1<-4,scanIndex2<-0,scanIndex3<-2 for average numer of wet spells>1 in a year	
					fontsize<-1.5
					linewidth<-2
					mainLength<-nchar("Average number of wet spells > 1 in a year")
					rfStatInAYearPlotFun(4,0,2,"Average number of wet spells > 1 in a year",nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)
				}
				#Maximum dry spell length in a year plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,9))){
					#scanIndex1<-5,scanIndex2<-0,scanIndex3<-1 for maximum dry spell length in a year
					fontsize<-1.5
					linewidth<-2
					mainLength<-nchar("Maximum dry spell length in a year")
					rfStatInAYearPlotFun(5,0,1,"Maximum dry spell length in a year",nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)
				}	
				#Average number of dry spells > 1 in a year plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,10))){
					#scanIndex1<-5,scanIndex1<-1,scanIndex3<-1 for average number of dry spells >1 in a year
					fontsize<-1.5
					linewidth<-2	
					mainLength<-nchar("Average number of dry spells >1 in a year")
					rfStatInAYearPlotFun(5,1,1,"Average number of dry spells >1 in a year",nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)
				}			 	
				#Daily log-odds ratio on annual basis plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,11))){
					fontsize<-1.5
					linewidth<-2
					annualCrsCorrlPlotFun(0,0,2,"Daily log-odds ratio on annual basis",nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
				}	
				 #Cross-corrl of number wet days on annual basis plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,12))){
					fontsize<-1.5
					linewidth<-2
					annualCrsCorrlPlotFun(1,2,1,c("Cross-correlation of number of", "\nwet days on annual basis"),nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)	
										
				}	
				#Mean of seasonal wet days plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,0))){
					wetDaysAnnualSeasonalMean<-matrix(scan(file=statFile,skip=0*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					fontsize<-1.2
					linewidth<-1
					mainLength<-nchar("Mean of seasonal wet days")
					seasonalStatPlotFun(wetDaysAnnualSeasonalMean,"Mean of seasonal wet days",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
				}	
				#SD of seasonal wet days plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,1))){
					wetDaysAnnualSeasonalSD<-matrix(scan(file=statFile,skip=3*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					fontsize<-1.2
					linewidth<-1
					mainLength<-nchar("Mean of seasonal wet days")
					seasonalStatPlotFun(wetDaysAnnualSeasonalSD,"SD of seasonal wet days",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
				}
				#Daily log-odds ratio on seasonal basis plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,2))){
					fontsize<-1.2
					linewidth<-1
					seasonalCrsCorrlPlotFun(0,0,2,"Daily log-odds ratio on seasonal basis",nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
				}	
				#Cross-corrl of number wet days on seasonal basis plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,3))){
					fontsize<-1.2
					linewidth<-1
					seasonalCrsCorrlPlotFun(1,2,1,c("Cross-correlation of number of wet days", "\non seasonal basis"),nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
				}
				#Mean of monthly wet days plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,0))){
					#col=[2:13] for station 1
					wetDaysMonthlyMean<-matrix(scan(file=statFile,skip=6*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
					mainLength<-nchar("Mean of monthly wet days")
					monthlyStatPlotFun(wetDaysMonthlyMean,"Mean of monthly wet days",nSim,nStation,rfStatSelStn,stnNumber,mainLength)
				}	
				#SD of monthly wet days plot
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,1))){
					#col=[2:13] for station 1
					wetDaysMonthlySD<-matrix(scan(file=statFile,skip=8*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
					mainLength<-nchar("SD of monthly wet days")
					monthlyStatPlotFun(wetDaysMonthlySD,"SD of monthly wet days",nSim,nStation,rfStatSelStn,stnNumber,mainLength)														
				}	
			}
			if (rfOccViewOption=="Grid"){
				#Mean of annual wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,0))){
					wetDaysAnnualSeasonalMean<-matrix(scan(file=statFile,skip=0*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-annualStatDfFun(wetDaysAnnualSeasonalMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)					 					
				}											 
				#SD of annual wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,1))){
					wetDaysAnnualSeasonalSD<-matrix(scan(file=statFile,skip=3*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-annualStatDfFun(wetDaysAnnualSeasonalSD,nSim,nStation,rfStatSelStn,stnNumber,stnName)						
				}						 					 
				#Maximum wet spell lengths df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,2))){
					rfOccMaxSpell5th<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)						 
					StatDf<-maxSpelllength5thRfAmtDfFun(rfOccMaxSpell5th,2,nSim,nStation,rfStatSelStn,stnNumber,stnName)	
				}										 
				#Maximum dry spell lengths df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,3))){
					rfOccMaxSpell5th<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)					 
					StatDf<-maxSpelllength5thRfAmtDfFun(rfOccMaxSpell5th,3,nSim,nStation,rfStatSelStn,stnNumber,stnName)	
				}																		 
				#Average Occurrence of wet spells of varying lengths df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,4))){ 
					avgOccOfWS<-matrix(scan(file=statFile,skip=11*(nSim+2)+0*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
					StatDf<-avgOccW_DSpellsDfFun(avgOccOfWS,"1-day","2-4 days","5-7 days","> 7 days","Wet Spell length",nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}						 						
				#Average Occurrence of dry spells of varying lengths df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,5))){
					avgOccOfDS<-matrix(scan(file=statFile,skip=11*(nSim+2)+2*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
					StatDf<-avgOccW_DSpellsDfFun(avgOccOfDS,"1-day","2-9 days","9-18 days","> 18 days","Dry Spell length",nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}												 
				#Number of wet days in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,6))){
					#scanIndex1<-1,scanIndex2<-0,scanIndex3<-2 for number of wet days in a year
					StatDf<-rfStatInAYearDfFun(1,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)
				}					 
				#Maximum wet spell length in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,7))){
					#scanIndex1<-3,scanIndex2<-0,scanIndex3<-2 for maximum wet spell length in a year 
					StatDf<-rfStatInAYearDfFun(3,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)							 
				}					 											
				#Average number of wet spells > 1 in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,8))){
					#scanIndex1<-4,scanIndex2<-0,scanIndex3<-2 for average numer of wet spells>1 in a year
					StatDf<-rfStatInAYearDfFun(4,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)
				}										
				#Maximum dry spell length in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,9))){
					#scanIndex1<-5,scanIndex2<-0,scanIndex3<-1 for maximum dry spell length in a year
					StatDf<-rfStatInAYearDfFun(5,0,1,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)
				}					 
				#Average number of dry spells > 1 in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,10))){
					#scanIndex1<-5,scanIndex1<-1,scanIndex3<-1 for average number of dry spells >1 in a year
					StatDf<-rfStatInAYearDfFun(5,1,1,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)
				}					
				#Daily log-odds ratio on annual basis df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,11))){
					StatDf<-annualCrsCorrlDfFun(0,0,2,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
				}	
				#Cross-corrl of number wet days on annual basis df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,12))){
					StatDf<-annualCrsCorrlDfFun(1,2,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
				}					 
				#Mean of seasonal wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,0))){
					wetDaysAnnualSeasonalMean<-matrix(scan(file=statFile,skip=0*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-seasonalStatDfFun(wetDaysAnnualSeasonalMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}						 
				#SD of seasonal wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,1))){
					wetDaysAnnualSeasonalSD<-matrix(scan(file=statFile,skip=3*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-seasonalStatDfFun(wetDaysAnnualSeasonalSD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}
				#Daily log-odds ratio on seasonal basis df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,2))){
					StatDf<-seasonalCrsCorrlDfFun(0,0,2,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
				}	
				#Cross-corrl of number wet days on seasonal basis df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,3))){
					StatDf<-seasonalCrsCorrlDfFun(1,2,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
				}					
				#Mean of monthly wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,0))){
					#col=[2:13] for station 1
					wetDaysMonthlyMean<-matrix(scan(file=statFile,skip=6*(nSim+2)+1,nlines=nSim+1, quiet=TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
					StatDf<-monthlyStatDfFun(wetDaysMonthlyMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}											
				#SD of monthly wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,1))){
					#col=[2:13] for station 1
					wetDaysMonthlySD<-matrix(scan(file=statFile,skip=8*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
					StatDf<-monthlyStatDfFun(wetDaysMonthlySD,nSim,nStation,rfStatSelStn,stnNumber,stnName)														
				}
				if (length(StatDf)==0){
					rfOccPlotDeviceAdd() 
				}
				if(length(StatDf)>1){
					model<-rGtkDataFrame(StatDf)
					model$setFrame(StatDf)
					column<-gtkTreeViewColumn()
					column$setTitle("Station Number")
					column$setSortColumnId(0)
					model$setSortColumnId (0,"ascending" )
					sorted_model<-gtkTreeModelSortNewWithModel(model)
					view<-gtkTreeView(sorted_model)
					mapply(view$insertColumnWithAttributes,position=-1,
						title=colnames(model),cell=list(gtkCellRendererText()),text=seq_len(ncol(model))-1)
					sapply(seq_len(ncol(model)),function(i)
						view$getColumn(i-1)$setSortColumnId(i-1))
					view$setHeadersClickable(TRUE)
					if (is.null(gtkCheckVersion(2, 10, 0))) view$setGridLines("both")	
					rfOccScrolledWindow<-gtkScrolledWindow()
					rfOccScrolledWindow$setSizeRequest(600,600)
					rfOccScrolledWindow$add(view)
					rfOccTable$attach(rfOccScrolledWindow,left.attach=1,2,top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")	
				}				
			}
		}				
    }   
}
rfOccOptionSel<-rfOccOptionView$getSelection()
gSignalConnect(rfOccOptionSel,"changed",function(rfOccOptionSel,event,data){
	list<-readLines("statistics_view_option.dat")
	isuccess=as.numeric(list[2])
	if (isuccess==1){
		rfOccOptionFun()
	}

})
#save rfOcc view
gSignalConnect(rfOccSaveViewButton, "clicked", function(rfOccSaveViewButton,event,data){
	if(length(rfOccOptionSel$getSelectedRows()$retval)==1){  
		statFile<-"stat.out"
		#Read user-defined parameters
		parameters<-scan(file="data.dat",skip=2,nline=1,quiet = TRUE)
		nYr<-parameters[1]
		yrStart<-parameters[2]
		band<-parameters[3]
		nStation<-parameters[4]
		nSim<-parameters[5]
		nYrSim<-parameters[8]
		nYrStat<-max(parameters[8],parameters[1]) #multi_site_rain.f L4643
		# Modified on 26 May 2017
		seasonIdx<-read.table("data.dat", header =FALSE, sep = "\t", nrows =1,skip = 8,strip.white = FALSE)
		seasonIdx1<-as.numeric(seasonIdx[1])
		seasonIdx2<-as.numeric(seasonIdx[2])
		seasonIdx3<-as.numeric(seasonIdx[3])
		seasonIdx4<-as.numeric(seasonIdx[4])
		seasonIdx5<-as.numeric(seasonIdx[5])
		seasonIdx6<-as.numeric(seasonIdx[6])
		seasonIdx7<-as.numeric(seasonIdx[7])
		seasonIdx8<-as.numeric(seasonIdx[8])
		seasonIdx9<-as.numeric(seasonIdx[9])
		seasonIdx10<-as.numeric(seasonIdx[10])
		seasonIdx11<-as.numeric(seasonIdx[11])
		seasonIdx12<-as.numeric(seasonIdx[12])
		
		inputDataFile<-FileLabel$getText()
		stnNumber<-read.table(inputDataFile,nrows=1)[2:(nStation+1)]	
	    stnName<-read.table(inputDataFile,skip=1,nrow=1,quote="\"")[2:(nStation+1)]
		#get view option from RadioButton gp
		sapply(rfOccViewOptionRadioGp,function(button,data){
			if(button['active']){
				list<-readLines("statistics_view_option.dat")
				list<-sub(list[4],button$getLabel(),list)
				writeLines(list,"statistics_view_option.dat") 
			}
		}) 
		list<-readLines("statistics_view_option.dat")
		rfOccViewOption<-list[4]
		rfStatSelStn<-rfOccStnCombo$getActiveText()
 		#rfOccPlotDeviceAdd()      				 				 														 																							
		if(length(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices())==2){
			if (rfOccViewOption=="Plot"){
				statPlot<-savePlotFileAs()
				if (statPlot!=""){
					#Mean of annual wet days plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,0))){
						wetDaysAnnualSeasonalMean<-matrix(scan(file=statFile,skip=0*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Mean of annual wet days")
						annualStatPlotFun(wetDaysAnnualSeasonalMean,"Mean of annual wet days",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)					 					
					}
					#SD of annual wet days plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,1))){
						wetDaysAnnualSeasonalSD<-matrix(scan(file=statFile,skip=3*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)					 
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("SD of annual wet days")
						annualStatPlotFun(wetDaysAnnualSeasonalSD,"SD of annual wet days",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)						
					}	
					#Maximum wet spell lengths plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,2))){
						rfOccMaxSpell5th<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1),
							nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)												 
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Maximum wet spell length")
						maxSpelllength5thRfAmtPlotFun(rfOccMaxSpell5th,2,"Maximum wet spell length",
							nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)	
					}
					#Maximum dry spell lengths plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,3))){
						rfOccMaxSpell5th<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)						 						 
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Maximum dry spell length")
						maxSpelllength5thRfAmtPlotFun(rfOccMaxSpell5th,3,"Maximum dry spell length",
							nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)	
					}
					#Average Occurrence of wet spells of varying lengths plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,4))){ 
						avgOccOfWS<-matrix(scan(file=statFile,skip=11*(nSim+2)+0*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),
						nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)						 
						dev.new(width=6.25, height=6.25)
						avgOccW_DSpellsPlotSaveFun(avgOccOfWS,"1-day","2-4 days","5-7 days","> 7 days",
												"Average occurrence of wet spells of varying lengths",
												nSim,nStation,rfStatSelStn,stnNumber)
					}	
					#Average Occurrence of dry spells of varying lengths plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,5))){
						avgOccOfDS<-matrix(scan(file=statFile,skip=11*(nSim+2)+2*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)						 						
						dev.new(width=6.25, height=6.25)
						avgOccW_DSpellsPlotSaveFun(avgOccOfDS,"1-day","2-9 days","9-18 days","> 18 days",
							"Average occurrence of dry spells of varying lengths",
							nSim,nStation,rfStatSelStn,stnNumber)
					}	
					#Number of wet days in a year plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,6))){
						#scanIndex1<-1,scanIndex2<-0,scanIndex3<-2 for number of wet days in a year
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Number of wet days in a year")
						rfStatInAYearPlotFun(1,0,2,"Number of wet days in a year",
							nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)
					}	
					#Maximum wet spell length in a year plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,7))){
						#scanIndex1<-3,scanIndex2<-0,scanIndex3<-2 for maximum wet spell length in a year 
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Maximum wet spell length in a year")
						rfStatInAYearPlotFun(3,0,2,"Maximum wet spell length in a year",
							nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)							 
					}	
					#Average number of wet spells > 1 in a year plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,8))){
						#scanIndex1<-4,scanIndex2<-0,scanIndex3<-2 for average numer of wet spells>1 in a year			
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Average number of wet spells > 1 in a year")
						rfStatInAYearPlotFun(4,0,2,"Average number of wet spells > 1 in a year",
							nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)
					}
					#Maximum dry spell length in a year plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,9))){
						#scanIndex1<-5,scanIndex2<-0,scanIndex3<-1 for maximum dry spell length in a year
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Maximum dry spell length in a year")
						rfStatInAYearPlotFun(5,0,1,"Maximum dry spell length in a year",
							nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)
					}	
					#Average number of dry spells > 1 in a year plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,10))){
						#scanIndex1<-5,scanIndex1<-1,scanIndex3<-1 for average number of dry spells >1 in a year						 
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						mainLength<-"Average number of dry spells >1 in a year"
						rfStatInAYearPlotFun(5,1,1,"Average number of dry spells >1 in a year",
							nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)
					}	
					#Daily log-odds ratio on annual basis
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,11)))
						{
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						annualCrsCorrlPlotFun(0,0,2,"Daily log-odds ratio on annual basis",nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}	
					#Cross-corrl of number wet days on annual basis
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,12)))
						{
						dev.new(width=6.25, height=6.25)
						fontsize<-1.5
						linewidth<-2
						annualCrsCorrlPlotFun(1,2,1,c("Cross-correlation of number of", "\nwet days on annual basis"),nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}					 
					#Mean of seasonal wet days plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,0)))	
						{
						wetDaysAnnualSeasonalMean<-matrix(scan(file=statFile,skip=0*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						dev.new(width=6.25, height=6.25)
						seasonalStatPlotSaveFun(wetDaysAnnualSeasonalMean,"Mean of seasonal wet days",nSim,nStation,rfStatSelStn,stnNumber)
						}	
					#SD of seasonal wet days plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,1)))	
						{
						wetDaysAnnualSeasonalSD<-matrix(scan(file=statFile,skip=3*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						dev.new(width=6.25, height=6.25)
						seasonalStatPlotSaveFun(wetDaysAnnualSeasonalSD,"SD of seasonal wet days",nSim,nStation,rfStatSelStn,stnNumber)
						}
					#Daily log-odds ratio on seasonal basis
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,2)))
						{
						dev.new(width=6.25, height=6.25)
						fontsize<-0.8
						linewidth<-1
						seasonalCrsCorrlSavePlotFun(0,0,2,"Daily log-odds ratio on seasonal basis",nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}	
					#Cross-corrl of number wet days on seasonal basis
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,3)))
						{
						dev.new(width=6.25, height=6.25)
						fontsize<-0.8
						linewidth<-1
						seasonalCrsCorrlSavePlotFun(1,2,1,c("Cross-correlation of number of wet days","\non seasonal basis"),nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}				 
					#Mean of monthly wet days plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,0)))	
						{
						#col=[2:13] for station 1
						wetDaysMonthlyMean<-matrix(scan(file=statFile,skip=6*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
						if (rfStatSelStn=="All stations") {dev.new(width=6.25, height=8.33)}
						else {dev.new(width=6.25, height=6.25)}
						mainLength<-nchar("Mean of monthly wet days")
						monthlyStatPlotSaveFun(wetDaysMonthlyMean,"Mean of monthly wet days",nSim,nStation,rfStatSelStn,stnNumber,mainLength)
						}	
					#SD of monthly wet days plot
					if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,1)))	
						{
						#col=[2:13] for station 1
						wetDaysMonthlySD<-matrix(scan(file=statFile,skip=8*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
						if (rfStatSelStn=="All stations") {dev.new(width=6.25, height=8.33)}
						else {dev.new(width=6.25, height=6.25)}
						mainLength<-nchar("SD of monthly wet days")
						monthlyStatPlotSaveFun(wetDaysMonthlySD,"SD of monthly wet days",nSim,nStation,rfStatSelStn,stnNumber,mainLength)														
						}
					savePlot(filename = statPlot,type = getExt(statPlot),device = dev.cur(),restoreConsole = TRUE)			 				 
					dev.off()
					}
				}
			 if (rfOccViewOption=="Grid"){
				#Mean of annual wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,0))){
					wetDaysAnnualSeasonalMean<-matrix(scan(file=statFile,skip=0*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
					nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-annualStatDfFun(wetDaysAnnualSeasonalMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)					 					
				}											 
				#SD of annual wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,1))){
					wetDaysAnnualSeasonalSD<-matrix(scan(file=statFile,skip=3*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
						nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-annualStatDfFun(wetDaysAnnualSeasonalSD,nSim,nStation,rfStatSelStn,stnNumber,stnName)						
				}						 					 
				#Maximum wet spell lengths df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,2))){
					rfOccMaxSpell5th<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
						nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)						 
					StatDf<-maxSpelllength5thRfAmtDfFun(rfOccMaxSpell5th,2,nSim,nStation,rfStatSelStn,stnNumber,stnName)	
				}										 
				#Maximum dry spell lengths df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,3))){
					rfOccMaxSpell5th<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)					 
					StatDf<-maxSpelllength5thRfAmtDfFun(rfOccMaxSpell5th,3,nSim,nStation,rfStatSelStn,stnNumber,stnName)	
				}																		 
				#Average Occurrence of wet spells of varying lengths df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,4))){ 
					avgOccOfWS<-matrix(scan(file=statFile,skip=11*(nSim+2)+0*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
					StatDf<-avgOccW_DSpellsDfFun(avgOccOfWS,"1-day","2-4 days","5-7 days","> 7 days","Wet Spell length",nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}						 						
				#Average Occurrence of dry spells of varying lengths df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,5))){
					avgOccOfDS<-matrix(scan(file=statFile,skip=11*(nSim+2)+2*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
					StatDf<-avgOccW_DSpellsDfFun(avgOccOfDS,"1-day","2-9 days","9-18 days","> 18 days","Dry Spell length",nSim,nStation,rfStatSelStn)
				}												 
				#Number of wet days in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,6))){
					#scanIndex1<-1,scanIndex2<-0,scanIndex3<-2 for number of wet days in a year
					StatDf<-rfStatInAYearDfFun(1,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)
				}					 
				#Maximum wet spell length in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,7))){
					#scanIndex1<-3,scanIndex2<-0,scanIndex3<-2 for maximum wet spell length in a year 
					StatDf<-rfStatInAYearDfFun(3,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)							 
				}					 											
				#Average number of wet spells > 1 in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,8))){
					#scanIndex1<-4,scanIndex2<-0,scanIndex3<-2 for average numer of wet spells>1 in a year
					StatDf<-rfStatInAYearDfFun(4,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)
				}										
				#Maximum dry spell length in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,9))){
					#scanIndex1<-5,scanIndex2<-0,scanIndex3<-1 for maximum dry spell length in a year
					StatDf<-rfStatInAYearDfFun(5,0,1,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)
				}					 
				#Average number of dry spells > 1 in a year df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,10))){
					#scanIndex1<-5,scanIndex1<-1,scanIndex3<-1 for average number of dry spells >1 in a year
					StatDf<-rfStatInAYearDfFun(5,1,1,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)
				}					
			    #Daily log-odds ratio on annual basis
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,11))){
					StatDf<-annualCrsCorrlDfFun(0,0,2,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
				}	
				#Cross-corrl of number wet days on annual basis
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,12))){
					StatDf<-annualCrsCorrlDfFun(1,2,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
				}							 
				#Mean of seasonal wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,0))){
					wetDaysAnnualSeasonalMean<-matrix(scan(file=statFile,skip=0*(nSim+2)+1,nlines=nSim+1),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-seasonalStatDfFun(wetDaysAnnualSeasonalMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}						 
				#SD of seasonal wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,1))){
					wetDaysAnnualSeasonalSD<-matrix(scan(file=statFile,skip=3*(nSim+2)+1,nlines=nSim+1),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-seasonalStatDfFun(wetDaysAnnualSeasonalSD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}
			    #Daily log-odds ratio on seasonal basis df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,2))){
					StatDf<-seasonalCrsCorrlDfFun(0,0,2,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
				}	
				#Cross-corrl of number wet days on seasonal basis df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,3))){
					StatDf<-seasonalCrsCorrlDfFun(1,2,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
				}						
				#Mean of monthly wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,0))){
					#col=[2:13] for station 1
					wetDaysMonthlyMean<-matrix(scan(file=statFile,skip=6*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
					StatDf<-monthlyStatDfFun(wetDaysMonthlyMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)
				}											
				#SD of monthly wet days df
				if (all(rfOccOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,1))){
					#col=[2:13] for station 1
					wetDaysMonthlySD<-matrix(scan(file=statFile,skip=8*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
					StatDf<-monthlyStatDfFun(wetDaysMonthlySD,nSim,nStation,rfStatSelStn,stnNumber,stnName)														
				}				 
				gridFile<-saveGridFileAs()
				if (gridFile!="") {
					write.table(StatDf, file = gridFile, append = FALSE, quote = TRUE,sep = " ",dec = ".",
					row.names = FALSE,col.names = TRUE, qmethod = "double",fileEncoding = "")	
				}							
			}
		}
	}
})

#Rainfall amount page
notebookStat$appendPage(rfAmtTable,gtkLabel("Rainfall Amount "))
rfAmtOptionFrame<-gtkFrame("Rainfall Amount")
rfAmtTable$attach(rfAmtOptionFrame,left.attach=0,1,top.attach=0,1,
	xoptions=c("shrink","fill"),yoptions="",ypadding=0)
aggregationList<-c("Annual","Seasonal","Monthly")
rfAmtAnnualList<-c("mean","SD","5th% (mm)",
	"mean per wet day","SD per wet day",
	"average in a year","maximum in a year",
	"total in wet spells of varying lengths",
	"daily cross-correlation of rainfall in wet days",
	"daily cross-correlation of rainfall in all days",
	"cross-correlation")
rfAmtSeasonalList<-c("mean","SD","mean per wet day","SD per wet day",
	"daily cross-correlation of rainfall in wet days",
	"daily cross-correlation of rainfall in all days",
	"cross-correlation")
rfAmtMonthlyList<-c("mean","SD")
rfAmtOption<-data.frame(aggregation=c(rep("Annual",length(rfAmtAnnualList)),
	rep("Seasonal",length(rfAmtSeasonalList)),
	rep("Monthly",length(rfAmtMonthlyList))),
	rfAmtStat=c(rfAmtAnnualList,rfAmtSeasonalList,rfAmtMonthlyList))
rfAmtOptionModel<-gtkTreeStore("gchararray")
by (rfAmtOption,rfAmtOption$aggregation,function(DF1){
	parent_iter <- rfAmtOptionModel$append()
	rfAmtOptionModel$setValue(parent_iter$iter,column = 0,value = DF1$aggregation)
	sapply ( DF1$rfAmtStat, function (rfAmtStat){
		child_iter <- rfAmtOptionModel$append(parent = parent_iter$iter)
		if (is.null(child_iter$retval))
		rfAmtOptionModel$setValue(child_iter$iter,column = 0 ,value = rfAmtStat)
	})
})
rfAmtOptionView<-gtkTreeView()
rfAmtOptionView$getSelection()$setMode("browse")
rfAmtOptionView$insertColumnWithAttributes(0,"              ",gtkCellRendererText(),text=0)
rfAmtOptionView$setModel(rfAmtOptionModel)
rfAmtScrolledWindow<-gtkScrolledWindow()
rfAmtScrolledWindow$setSizeRequest(200,600)
rfAmtScrolledWindow$add(rfAmtOptionView)
rfAmtOptionFrame$add(rfAmtScrolledWindow)

#Function to view rainfall amount statistics 
rfAmtOptionFun<-function(){
	if (length(dev.list())>1) dev.off()
	#Read user-defined parameters
	parameters<-scan(file="data.dat",skip=2,nline=1,quiet = TRUE)
	nYr<-parameters[1]
	yrStart<-parameters[2]
	band<-parameters[3]
	nStation<-parameters[4]
	nSim<-parameters[5]
	nYrSim<-parameters[8]
	nYrStat<-max(parameters[8],parameters[1])#multi_site_rain.f L4643
	# Modified on 26 May 2017
	seasonIdx<-read.table("data.dat", header =FALSE, sep = "\t", nrows =1,skip = 8,strip.white = FALSE)
	seasonIdx1<-as.numeric(seasonIdx[1])
	seasonIdx2<-as.numeric(seasonIdx[2])
	seasonIdx3<-as.numeric(seasonIdx[3])
	seasonIdx4<-as.numeric(seasonIdx[4])
	seasonIdx5<-as.numeric(seasonIdx[5])
	seasonIdx6<-as.numeric(seasonIdx[6])
	seasonIdx7<-as.numeric(seasonIdx[7])
	seasonIdx8<-as.numeric(seasonIdx[8])
	seasonIdx9<-as.numeric(seasonIdx[9])
	seasonIdx10<-as.numeric(seasonIdx[10])
	seasonIdx11<-as.numeric(seasonIdx[11])
	seasonIdx12<-as.numeric(seasonIdx[12])
	
	amt<-parameters[10]
	if (amt==1){
		if(length(rfAmtOptionSel$getSelectedRows()$retval)==1){
			sapply(rfAmtViewOptionRadioGp,function(button,data){ 
				if(button['active']){
				list<-readLines("statistics_view_option.dat")
				list<-sub(list[6],button$getLabel(),list)
				writeLines(list,"statistics_view_option.dat") 
				}
			}) 
			list<-readLines("statistics_view_option.dat")
			rfAmtViewOption<-list[6]
			rfStatSelStn<-rfAmtStnCombo$getActiveText()		 
			statFile<-"stat.out"
			inputDataFile<-FileLabel$getText()
			if (nStation==1) {
				stnNumber<-read.table(inputDataFile,nrows=1)[2]
				stnName<-read.table(inputDataFile,skip=1,nrow=1,quote="\"")[2]
			}
			if (nStation>=2) {
				stnNumber<-read.table(inputDataFile,nrows=1)[2:(nStation+1)]
				stnName<-read.table(inputDataFile,skip=1,nrow=1,quote="\"")[2:(nStation+1)]
			}

			if (length(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices())==2){
				if (rfAmtViewOption=="Plot"){
					rfAmtPlotDeviceAdd()											 
					#Mean of annual rf amt plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,0))){
						rfAmtAnnualSeasonalMean<-matrix(scan(file=statFile,skip=(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Mean of annual rainfall amount")
						annualStatPlotFun(rfAmtAnnualSeasonalMean,"Mean of annual rainfall amount",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
					}
					#SD of annual rf amt plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,1))){
						rfAmtAnnualSeasonalSD<-matrix(scan(file=statFile,skip=4*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						fontsize<-1.5 #STOP HERE
						linewidth<-2
						mainLength<-nchar("SD of annual rainfall amount")
						annualStatPlotFun(rfAmtAnnualSeasonalSD,"SD of annual rainfall amount",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
					}
					#5th percentile of rf amt plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,2))){
						MaxSpell5thRfAmt<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("5th percentile of daily rainfall amount")
						maxSpelllength5thRfAmtPlotFun(MaxSpell5thRfAmt,4,"5th percentile of daily rainfall amount",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)													
					}
					#Mean of annual rf amt per wet day plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,3))){
						rfAmtAnnualSeasonalMeanPWD<-matrix(scan(file=statFile,skip=2*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						fontsize<-1.5
						linewidth<-2
						mainLength=nchar("Mean of annual rainfall amount per wet day")
						annualStatPlotFun(rfAmtAnnualSeasonalMeanPWD,"Mean of annual rainfall amount per wet day",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
					}
					#SD of annual rf amt per wet day plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,4))){
						rfAmtAnnualSeasonalSDPWD<-matrix(scan(file=statFile,skip=5*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("SD of annual rainfall amount per wet day")
						annualStatPlotFun(rfAmtAnnualSeasonalSDPWD,"SD of annual rainfall amount per wet day",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
					}
					#Average rf amt in a year plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,5))){
						#scanIndex<-2 for average rf amt in a year
						fontsize<-1.5
						linewidth<-2
						mainLength<-nchar("Average rainfall in a year")
						rfStatInAYearPlotFun(2,0,2,"Average rainfall in a year",nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)								 				
					}
					#Maximum rf amt in a year plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,6))){
						#scanIndex<-0 for maximum rf amt in a year						
						fontsize<-1.5
						linewidth<-2					
						mainLength<-nchar("Maximum rainfall amount in a year")
						rfStatInAYearPlotFun(0,0,2,"Maximum rainfall amount in a year",nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)					
					}
					#Total rf amt in wet spells of varying lengths plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,7))){
						totRfAmtInWS<-matrix(scan(file=statFile,skip=11*(nSim+2)+1*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
						fontsize<-1.2
						linewidth<-1
						totRfAmtInWSPlotFun(totRfAmtInWS,"1-day","2-4 days","5-7 days","> 7 days",
							"Total rainfall in wet spells of varying lengths",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth)						
					}						
					#Daily crs-corrl of rf-wet days on annual basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,8))){
						fontsize<-1.5
						linewidth<-2
						annualCrsCorrlPlotFun(1,0,1,c("Daily cross-correlation of rainfall", "\n in wet days on annual basis"),nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
					}	
					#Daily crs-corrl of rf-all days on annual basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,9))){
						fontsize<-1.5
						linewidth<-2
						annualCrsCorrlPlotFun(1,1,1,c("Daily cross-correlation of rainfall", "\nin all days on annual basis"),nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
					}
					#Cross-corrl of annual rainfall
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,10))){
						fontsize<-1.5
						linewidth<-2
						annualCrsCorrlPlotFun(1,3,1,"Cross-correlation of annual rainfall",nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
					}
					#Mean of seasonal rf amt plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,0))){
						rfAmtAnnualSeasonalMean<-matrix(scan(file=statFile,skip=(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						fontsize<-1.2
						linewidth<-1
						mainLength<-nchar("Mean of seasonal rainfall amount")
						seasonalStatPlotFun(rfAmtAnnualSeasonalMean,"Mean of seasonal rainfall amount",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
					}	
					#SD of seasonal rf amt plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,1))){
						rfAmtAnnualSeasonalSD<-matrix(scan(file=statFile,skip=4*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						fontsize<-1.2
						linewidth<-1
						mainLength<-nchar("SD of seasonal rainfall amount")
						seasonalStatPlotFun(rfAmtAnnualSeasonalSD,"SD of seasonal rainfall amount",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)						 
					}
					#Mean of seasonal rf amt per wet day plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,2))){
						rfAmtAnnualSeasonalMeanPWD<-matrix(scan(file=statFile,skip=2*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						fontsize<-1.2
						linewidth<-1
						mainLength<-nchar("Mean of seasonal rainfall amount per wet day")
						seasonalStatPlotFun(rfAmtAnnualSeasonalMeanPWD,"Mean of seasonal rainfall amount per wet day",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)	
					}
					#SD of seasonal rf amt per wet day plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,3))){
						rfAmtAnnualSeasonalSDPWD<-matrix(scan(file=statFile,skip=5*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						fontsize<-1.2
						linewidth<-1
						mainLength<-nchar("SD of seasonal rainfall amount per wet day")
						seasonalStatPlotFun(rfAmtAnnualSeasonalSDPWD,"SD of seasonal rainfall amount per wet day",nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
					}
					#Daily crs-corrl of rf-wet days on seasonal basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,4))){
						fontsize<-1.2
						linewidth<-1
						seasonalCrsCorrlPlotFun(1,0,1,c("Daily cross-correlation of rainfall","\nin wet days on seasonal basis"),nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
					}	
					#Daily crs-corrl of rf-all days on seasonal basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,5))){
						fontsize<-1.2
						linewidth<-1
						seasonalCrsCorrlPlotFun(1,1,1,c("Daily cross-correlation of rainfall","\nin all days on seasonal basis"),nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
					}
					#Cross-corrl of seasonal rainfall
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,6))){
						fontsize<-1.2
						linewidth<-1
						seasonalCrsCorrlPlotFun(1,3,1,"Cross-correlation of seasonal rainfall",nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
					}
					#Mean of monthly rf amt plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,0))){
						#col=[2:13] for station 1
						rfAmtMonthlyMean<-matrix(scan(file=statFile,skip=7*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
						mainLength<-nchar("Mean of monthly rainfall amount")
						monthlyStatPlotFun(rfAmtMonthlyMean,"Mean of monthly rainfall amount",nSim,nStation,rfStatSelStn,stnNumber,mainLength)
					}					 
					#SD of monthly rf amt plot
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,1))){
						#col=[2:13] for station 1
						rfAmtMonthlySD<-matrix(scan(file=statFile,skip=9*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
						mainLength<-nchar("SD of monthly rainfall amount")
						monthlyStatPlotFun(rfAmtMonthlySD,"SD of monthly rainfall amount",nSim,nStation,rfStatSelStn,stnNumber,mainLength)
					}
				}											
				if (rfAmtViewOption=="Grid"){
					#Mean of annual rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,0))){
						rfAmtAnnualSeasonalMean<-matrix(scan(file=statFile,skip=(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-annualStatDfFun(rfAmtAnnualSeasonalMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)			
					}					
					#SD of annual rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,1))){
						rfAmtAnnualSeasonalSD<-matrix(scan(file=statFile,skip=4*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-annualStatDfFun(rfAmtAnnualSeasonalSD,nSim,nStation,rfStatSelStn,stnNumber,stnName)								 
					}											 						
					#5th percentile of rf df 
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,2))){
						MaxSpell5thRfAmt<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)
						StatDf<-maxSpelllength5thRfAmtDfFun(MaxSpell5thRfAmt,4,nSim,nStation,rfStatSelStn,stnNumber,stnName)													
					}						
					#Mean of annual rf amt per wet day df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,3))){
						rfAmtAnnualSeasonalMeanPWD<-matrix(scan(file=statFile,skip=2*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-annualStatDfFun(rfAmtAnnualSeasonalMeanPWD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}					 
					#SD of annual rf amt per wet day df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,4))){
						rfAmtAnnualSeasonalSDPWD<-matrix(scan(file=statFile,skip=5*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-annualStatDfFun(rfAmtAnnualSeasonalSDPWD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}
					#Average rf amt in a year df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,5))){
						#scanIndex<-2 for average rf amt in a year
						StatDf<-rfStatInAYearDfFun(2,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)								 				
					}					 					 
					#Maximum rf amt in a year df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,6))){
						#scanIndex<-0 for maximum rf amt in a year						 
						StatDf<-rfStatInAYearDfFun(0,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)					
					}					 
					#Total rf amt in wet spells of varying lengths df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,7))){
						totRfAmtInWS<-matrix(scan(file=statFile,skip=11*(nSim+2)+1*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
						StatDf<-totRfAmtInWSDfFun(totRfAmtInWS,"1-day","2-4 days","5-7 days","> 7 days","Wet Spell Lengths",nSim,nStation,rfStatSelStn,stnNumber,stnName)						
					}						
					#Daily crs-corrl of rf-wet days on annual basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,8))){
						StatDf<-annualCrsCorrlDfFun(1,0,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)					 
					}	
					#Daily crs-corrl of rf-all days on annual basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,9))){
						StatDf<-annualCrsCorrlDfFun(1,1,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}
					#Cross-corrl of annual rainfall
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,10))){
						StatDf<-annualCrsCorrlDfFun(1,3,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}										
					#Mean of seasonal rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,0))){
						rfAmtAnnualSeasonalMean<-matrix(scan(file=statFile,skip=(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-seasonalStatDfFun(rfAmtAnnualSeasonalMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}					 					 
					#SD of seasonal rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,1))){
						rfAmtAnnualSeasonalSD<-matrix(scan(file=statFile,skip=4*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-seasonalStatDfFun(rfAmtAnnualSeasonalSD,nSim,nStation,rfStatSelStn,stnNumber,stnName)						 
					}						
					#Mean of seasonal rf amt per wet day df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,2))){
					rfAmtAnnualSeasonalMeanPWD<-matrix(scan(file=statFile,skip=2*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-seasonalStatDfFun(rfAmtAnnualSeasonalMeanPWD,nSim,nStation,rfStatSelStn,stnNumber,stnName)	
					}					 
					#SD of seasonal rf amt per wet day df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,3))){
					rfAmtAnnualSeasonalSDPWD<-matrix(scan(file=statFile,skip=5*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
					StatDf<-seasonalStatDfFun(rfAmtAnnualSeasonalSDPWD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}
					#Daily crs-corrl of rf-wet days on seasonal basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,4))){
					StatDf<-seasonalCrsCorrlDfFun(1,0,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}	
					#Daily crs-corrl of rf-all days on seasonal basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,5))){
					StatDf<-seasonalCrsCorrlDfFun(1,1,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}
					#Cross-corrl of seasonal rainfall
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,6))){
					StatDf<-seasonalCrsCorrlDfFun(1,3,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}				 				 
					#Mean of monthly rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,0)))
					{
					#col=[2:13] for station 1
					rfAmtMonthlyMean<-matrix(scan(file=statFile,skip=7*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
					StatDf<-monthlyStatDfFun(rfAmtMonthlyMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}											 
					#SD of monthly rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,1))){
						#col=[2:13] for station 1
						rfAmtMonthlySD<-matrix(scan(file=statFile,skip=9*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
						StatDf<-monthlyStatDfFun(rfAmtMonthlySD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}
					if (length(StatDf)==0){
						rfAmtPlotDeviceAdd() 
					}
					if(length(StatDf)>1){				
						model<-rGtkDataFrame(StatDf)
						model$setFrame(StatDf)
						column<-gtkTreeViewColumn()
						column$setTitle("Station Number")
						column$setSortColumnId(0)
						model$setSortColumnId (0,"ascending" )
						sorted_model<-gtkTreeModelSortNewWithModel(model)
						view<-gtkTreeView(sorted_model)
						mapply(view$insertColumnWithAttributes,position=-1,
							title=colnames(model),cell=list(gtkCellRendererText()),text=seq_len(ncol(model))-1)
						sapply(seq_len(ncol(model)),function(i)
							view$getColumn(i-1)$setSortColumnId(i-1))
						view$setHeadersClickable(TRUE)
						if (is.null(gtkCheckVersion(2, 10, 0))) view$setGridLines("both")	
						rfAmtScrolledWindow<-gtkScrolledWindow()
						rfAmtScrolledWindow$setSizeRequest(600,600)
						rfAmtScrolledWindow$add(view)
						rfAmtTable$attach(rfAmtScrolledWindow,left.attach=1,2,top.attach=0,1,xoptions=c("shrink","fill"),yoptions="")		
					}					
				}
			}
			
		}
	}
}						
rfAmtOptionSel<-rfAmtOptionView$getSelection()
gSignalConnect(rfAmtOptionSel,"changed",function(rfAmtOptionSel,event,data){
	list<-readLines("statistics_view_option.dat")
	isuccess=as.numeric(list[2])
	if (isuccess==1) {rfAmtOptionFun()}
})	
#Add combo box for station select
rfAmtStnSelFrame<-gtkFrame("Select Station: ")
rfAmtTable$attach(rfAmtStnSelFrame,left.attach=0,1,top.attach=1,2,
	xoptions=c("shrink","fill"),yoptions="",ypadding=0)
rfAmtStnCombo <- gtkComboBoxNewText()
rfAmtStnSelFrame$add(rfAmtStnCombo)	
gSignalConnect(rfAmtStnCombo,"changed",f = function(button,...){
   	#message("",button$getActiveText(),"\n")
	list<-readLines("statistics_view_option.dat")
	isuccess=as.numeric(list[2])
	if (isuccess==1) {rfAmtOptionFun()}
})
#Add RadioButton for view options
rfAmtViewOptionFrame<-gtkFrame("View Options")
rfAmtTable$attach(rfAmtViewOptionFrame,left.attach=1,2,top.attach=1,2,
	xoptions=c("expand","fill"),yoptions="",ypadding=0)
rfAmtViewOptionLabels<-c("Grid","Plot")
rfAmtViewOptionRadioGp<-list() 
rfAmtViewOptionRadioGp [[rfAmtViewOptionLabels[1]]]<-gtkRadioButton(label=rfAmtViewOptionLabels[1])
for(label in rfAmtViewOptionLabels [-1])
rfAmtViewOptionRadioGp[[label]]<-gtkRadioButton(rfAmtViewOptionRadioGp,label=label)
rfAmtViewOptionHBox<-gtkHBox(homogeneous = NULL,spacing = NULL,show = TRUE)
rfAmtViewOptionFrame$add(rfAmtViewOptionHBox)
sapply(rfAmtViewOptionRadioGp,gtkBoxPackStart,object=rfAmtViewOptionHBox)
rfAmtViewOptionHBox[[2]]$setActive(TRUE) #set scatter plot as initial value
sapply(rfAmtViewOptionRadioGp,'[',"active")
sapply(rfAmtViewOptionRadioGp,gSignalConnect,"toggled",function(button,data){
	if(button['active']){
		#message("",button$getLabel(),"\n")
		list<-readLines("statistics_view_option.dat")
		isuccess=as.numeric(list[2])
		if (isuccess==1) {rfAmtOptionFun()}
	}
})	
rfAmtSaveViewButton<-gtkButtonNewWithLabel("Save View")
rfAmtTable$attach(rfAmtSaveViewButton,left.attach=0,1,top.attach=2,3,
	xoptions=c("shrink","fill"),yoptions="",ypadding=0)	
#Add plot device to rfAmtTable
rfAmtPlotDeviceAdd<-function(){				 				
	rfAmtPlotDevice<-gtkDrawingArea()
	rfAmtPlotDevice$setSizeRequest(600,600)
	asCairoDevice(rfAmtPlotDevice)
	rfAmtTable$attach(rfAmtPlotDevice,left.attach=1,2,top.attach=0,1,
		xoptions=c("expand","fill"),yoptions="",ypadding=0)
	Sys.sleep(.1)
}

#save rfAmt view
gSignalConnect(rfAmtSaveViewButton, "clicked", function(rfAmtSaveViewButton,event,data){
	#Read user-defined parameters
	parameters<-scan(file="data.dat",skip=2,nline=1,quiet = TRUE)
	nYr<-parameters[1]
	yrStart<-parameters[2]
	band<-parameters[3]
	nStation<-parameters[4]
	nSim<-parameters[5]
	nYrSim<-parameters[8]
	nYrStat<-max(parameters[8],parameters[1]) #multi_site_rain.f L4643
	
	# Modified on 26 May 2017
	seasonIdx<-read.table("data.dat", header =FALSE, sep = "\t", nrows =1,skip = 8,strip.white = FALSE)
	seasonIdx1<-as.numeric(seasonIdx[1])
	seasonIdx2<-as.numeric(seasonIdx[2])
	seasonIdx3<-as.numeric(seasonIdx[3])
	seasonIdx4<-as.numeric(seasonIdx[4])
	seasonIdx5<-as.numeric(seasonIdx[5])
	seasonIdx6<-as.numeric(seasonIdx[6])
	seasonIdx7<-as.numeric(seasonIdx[7])
	seasonIdx8<-as.numeric(seasonIdx[8])
	seasonIdx9<-as.numeric(seasonIdx[9])
	seasonIdx10<-as.numeric(seasonIdx[10])
	seasonIdx11<-as.numeric(seasonIdx[11])
	seasonIdx12<-as.numeric(seasonIdx[12])
	
	amt<-parameters[10]	
	if (amt==1){							
		if(length(rfAmtOptionSel$getSelectedRows()$retval)==1){
			sapply(rfAmtViewOptionRadioGp,function(button,data){ 
				if(button['active']) {
					list<-readLines("statistics_view_option.dat")
					list<-sub(list[6],button$getLabel(),list)
					writeLines(list,"statistics_view_option.dat") 
				}
			}) 
			list<-readLines("statistics_view_option.dat")
			rfAmtViewOption<-list[6]
			rfStatSelStn<-rfAmtStnCombo$getActiveText()		 
			statFile<-"stat.out"
			inputDataFile<-FileLabel$getText()
			if (nStation==1) {
				stnNumber<-read.table(inputDataFile,nrows=1)[2]
				stnName<-read.table(inputDataFile,skip=1,nrow=1,quote="\"")[2]
			}
			if (nStation>=2) {
				stnNumber<-read.table(inputDataFile,nrows=1)[2:(nStation+1)]
				stnName<-read.table(inputDataFile,skip=1,nrow=1,quote="\"")[2:(nStation+1)]
			}
			if (length(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices())==2){
				if (rfAmtViewOption=="Plot"){
					statPlot<-savePlotFileAs()	
					if (statPlot!=""){
						#Mean of annual rf amt plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,0))){
							rfAmtAnnualSeasonalMean<-matrix(scan(file=statFile,skip=(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							mainLength<-nchar("Mean of annual rainfall amount")
							annualStatPlotFun(rfAmtAnnualSeasonalMean,"Mean of annual rainfall amount",
								nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
						}
						#SD of annual rf amt plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,1))){
							rfAmtAnnualSeasonalSD<-matrix(scan(file=statFile,skip=4*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							mainLength<-nchar("SD of annual rainfall amount")
							annualStatPlotFun(rfAmtAnnualSeasonalSD,"SD of annual rainfall amount",
								nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
						}
						#5th percentile of rf amt plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,2))){
							MaxSpell5thRfAmt<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1),
								nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							mainLength<-nchar("5th percentile of daily rainfall amount")
							maxSpelllength5thRfAmtPlotFun(MaxSpell5thRfAmt,4,
								"5th percentile of daily rainfall amount",nSim,
								nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)													
						}
						#Mean of annual rf amt per wet day plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,3))){
							rfAmtAnnualSeasonalMeanPWD<-matrix(scan(file=statFile,skip=2*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							mainLength<-nchar("Mean of annual rainfall amount per wet day")
							annualStatPlotFun(rfAmtAnnualSeasonalMeanPWD,"Mean of annual rainfall amount per wet day",
								nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth,mainLength)
						}
						#SD of annual rf amt per wet day plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,4))){
							rfAmtAnnualSeasonalSDPWD<-matrix(scan(file=statFile,skip=5*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							mainLenght<-nchar("SD of annual rainfall amount per wet day")
							annualStatPlotFun(rfAmtAnnualSeasonalSDPWD,"SD of annual rainfall amount per wet day",
								nSim,nStation,rfStatSelStn,stnNumber,fontsize,linewidth)
						}
						#Average rf amt in a year plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,5))){
							#scanIndex<-2 for average rf amt in a year
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							mainLength<-nchar("Average rainfall in a year")
							rfStatInAYearPlotFun(2,0,2,"Average rainfall in a year",
								nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)								 				
						}
						#Maximum rf amt in a year plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,6))){
							#scanIndex<-0 for maximum rf amt in a year						 
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							mainLength<-nchar("Maximum rainfall amount in a year")
							rfStatInAYearPlotFun(0,0,2,"Maximum rainfall amount in a year",
								nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,fontsize,linewidth,mainLength)					
						}
						#Total rf amt in wet spells of varying lengths plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,7))){
							totRfAmtInWS<-matrix(scan(file=statFile,skip=11*(nSim+2)+1*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							totRfAmtInWSPlotSaveFun(totRfAmtInWS,"1-day","2-4 days","5-7 days","> 7 days",
								"Total rainfall wet spells of varying lengths",
								nSim,nStation,rfStatSelStn,stnNumber)						
						}
						#Daily crs-corrl of rf-wet days on annual basis
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,8))){
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							annualCrsCorrlPlotFun(1,0,1,c("Daily cross-correlation of rainfall", "\nin wet days on annual basis"),
								nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}	
						#Daily crs-corrl of rf-all days on annual basis
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,9))){
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							annualCrsCorrlPlotFun(1,1,1,c("Daily cross-correlation of rainfall", "\nin all days on annual basis"),
								nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}
						#Cross-corrl of annual rainfall
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,10))){
							dev.new(width=6.25, height=6.25)
							fontsize<-1.5
							linewidth<-2
							annualCrsCorrlPlotFun(1,3,1,"Cross-correlation of annual rainfall",
								nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}				
						#Mean of seasonal rf amt plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,0))){
							rfAmtAnnualSeasonalMean<-matrix(scan(file=statFile,skip=(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							seasonalStatPlotSaveFun(rfAmtAnnualSeasonalMean,"Mean of seasonal rainfall",
								nSim,nStation,rfStatSelStn,stnNumber)
						}	
						#SD of seasonal rf amt plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,1))){
							rfAmtAnnualSeasonalSD<-matrix(scan(file=statFile,skip=4*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							seasonalStatPlotSaveFun(rfAmtAnnualSeasonalSD,"SD of seasonal rainfall",
								nSim,nStation,rfStatSelStn,stnNumber)						 
						}
						#Mean of seasonal rf amt per wet day plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,2))){
							rfAmtAnnualSeasonalMeanPWD<-matrix(scan(file=statFile,skip=2*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							seasonalStatPlotSaveFun(rfAmtAnnualSeasonalMeanPWD,
								"Mean of seasonal rainfall per wet day",
								nSim,nStation,rfStatSelStn,stnNumber)	
						}
						#SD of seasonal rf amt per wet day plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,3))){
							rfAmtAnnualSeasonalSDPWD<-matrix(scan(file=statFile,skip=5*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
							dev.new(width=6.25, height=6.25)
							seasonalStatPlotSaveFun(rfAmtAnnualSeasonalSDPWD,
								"SD of seasonal rainfall per wet day",
								nSim,nStation,rfStatSelStn,stnNumber)
						}
						#Daily crs-corrl of rf-wet days on seasonal basis
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,4))){
							dev.new(width=6.25, height=6.25)
							fontsize<-0.8
							linewidth<-1
							seasonalCrsCorrlSavePlotFun(1,0,1,c("Daily cross-correlation of rainfall","\nin wet days on seasonal basis"),
								nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}	
						#Daily crs-corrl of rf-all days on seasonal basis
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,5))){
							dev.new(width=6.25, height=6.25)
							fontsize<-0.8
							linewidth<-1
							seasonalCrsCorrlSavePlotFun(1,1,1,c("Daily cross-correlation of rainfall","\nin all days on seasonal basis"),
								nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}
						#Cross-corrl of seasonal rainfall
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,6))){
							dev.new(width=6.25, height=6.25)
							fontsize<-0.8
							linewidth<-1
							seasonalCrsCorrlSavePlotFun(1,3,1,"Cross-Correlation of Seasonal Rainfall",
								nSim,nStation,statFile,nYrStat,stnNumber,fontsize,linewidth)						
						}				 
						#Mean of monthly rf amt plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,0))){
							#col=[2:13] for station 1
							rfAmtMonthlyMean<-matrix(scan(file=statFile,skip=7*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
							if (rfStatSelStn=="All stations") {dev.new(width=6.25, height=8.33)}
							else {dev.new(width=6.25, height=6.25)}		
							mainLength<-nchar("Mean of monthly rainfall amount")
							monthlyStatPlotSaveFun(rfAmtMonthlyMean,"Mean of monthly rainfall amount",
								nSim,nStation,rfStatSelStn,stnNumber,mainLength)
						}					 
						#SD of monthly rf amt plot
						if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,1))){
							#col=[2:13] for station 1
							rfAmtMonthlySD<-matrix(scan(file=statFile,skip=9*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
								nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
							if (rfStatSelStn=="All stations") {dev.new(width=6.25, height=8.33)}
							else {dev.new(width=6.25, height=6.25)}
							mainLength<-nchar("SD of monthly rainfall amount")
							monthlyStatPlotSaveFun(rfAmtMonthlySD,"SD of monthly rainfall amount",
								nSim,nStation,rfStatSelStn,stnNumber,mainLength)
						}
						savePlot(filename = statPlot,type = getExt(statPlot),device = dev.cur(),restoreConsole = TRUE)			 				 
						dev.off()
					}
				}
				if (rfAmtViewOption=="Grid"){
					#Mean of annual rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,0))){
						rfAmtAnnualSeasonalMean<-matrix(scan(file=statFile,skip=(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-annualStatDfFun(rfAmtAnnualSeasonalMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)			
					}					
					#SD of annual rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,1))){
						rfAmtAnnualSeasonalSD<-matrix(scan(file=statFile,skip=4*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-annualStatDfFun(rfAmtAnnualSeasonalSD,nSim,nStation,rfStatSelStn,stnNumber,stnName)								 
					}											 						
					#5th percentile of rf df 
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,2))){
						MaxSpell5thRfAmt<-matrix(scan(file=statFile,skip=10*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+3*nStation,byrow=TRUE)
						StatDf<-maxSpelllength5thRfAmtDfFun(MaxSpell5thRfAmt,4,nSim,nStation,rfStatSelStn,stnNumber,stnName)													
					}						
					#Mean of annual rf amt per wet day df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,3))){
						rfAmtAnnualSeasonalMeanPWD<-matrix(scan(file=statFile,skip=2*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-annualStatDfFun(rfAmtAnnualSeasonalMeanPWD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}					 
					#SD of annual rf amt per wet day df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,4))){
						rfAmtAnnualSeasonalSDPWD<-matrix(scan(file=statFile,skip=5*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-annualStatDfFun(rfAmtAnnualSeasonalSDPWD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}
					#Average rf amt in a year df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,5))){
						#scanIndex<-2 for average rf amt in a year
						StatDf<-rfStatInAYearDfFun(2,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)								 				
					}					 					 
					#Maximum rf amt in a year df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,6))){
						#scanIndex<-0 for maximum rf amt in a year						 
						StatDf<-rfStatInAYearDfFun(0,0,2,nSim,nStation,rfStatSelStn,statFile,nYrStat,stnNumber,stnName)					
					}					 
					#Total rf amt in wet spells of varying lengths df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,7))){
						totRfAmtInWS<-matrix(scan(file=statFile,skip=11*(nSim+2)+1*(nSim+3)+2,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+4*nStation,byrow=TRUE)
						StatDf<-totRfAmtInWSDfFun(totRfAmtInWS,"1-day","2-4 days","5-7 days","> 7 days",
							"Wet Spells lengths",nSim,nStation,rfStatSelStn,stnNumber,stnName)						
					}																	 
					#Daily crs-corrl of rf-wet days on annual basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,8))){
						StatDf<-annualCrsCorrlDfFun(1,0,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}	
					#Daily crs-corrl of rf-all days on annual basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,9))){
						StatDf<-annualCrsCorrlDfFun(1,1,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}
					#Cross-corrl of annual rainfall
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(0,10))){
						StatDf<-annualCrsCorrlDfFun(1,3,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}								 
					#Mean of seasonal rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,0))){
						rfAmtAnnualSeasonalMean<-matrix(scan(file=statFile,skip=(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-seasonalStatDfFun(rfAmtAnnualSeasonalMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}					 					 
					#SD of seasonal rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,1))){
						rfAmtAnnualSeasonalSD<-matrix(scan(file=statFile,skip=4*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-seasonalStatDfFun(rfAmtAnnualSeasonalSD,nSim,nStation,rfStatSelStn,stnNumber,stnName)						 
					}						
					#Mean of seasonal rf amt per wet day df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,2))){
						rfAmtAnnualSeasonalMeanPWD<-matrix(scan(file=statFile,skip=2*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-seasonalStatDfFun(rfAmtAnnualSeasonalMeanPWD,nSim,nStation,rfStatSelStn,stnNumber,stnName)	
					}					 
					#SD of seasonal rf amt per wet day df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,3))){
						rfAmtAnnualSeasonalSDPWD<-matrix(scan(file=statFile,skip=5*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+5*nStation,byrow=TRUE)
						StatDf<-seasonalStatDfFun(rfAmtAnnualSeasonalSDPWD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}
					#Daily crs-corrl of rf-wet days on seasonal basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,4))){
						StatDf<-seasonalCrsCorrlDfFun(1,0,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}	
					#Daily crs-corrl of rf-all days on seasonal basis
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,5))){
						StatDf<-seasonalCrsCorrlDfFun(1,1,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}
					#Cross-corrl of seasonal rainfall
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(2,6))){
						StatDf<-seasonalCrsCorrlDfFun(1,3,1,nSim,nStation,statFile,nYrStat,stnNumber,stnName)						
					}				 			 			 
					#Mean of monthly rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,0))){
						#col=[2:13] for station 1
						rfAmtMonthlyMean<-matrix(scan(file=statFile,skip=7*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
						StatDf<-monthlyStatDfFun(rfAmtMonthlyMean,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}											 
					#SD of monthly rf amt df
					if (all(rfAmtOptionSel$getSelectedRows()$retval[[1]]$getIndices()==c(1,1))){
						#col=[2:13] for station 1
						rfAmtMonthlySD<-matrix(scan(file=statFile,skip=9*(nSim+2)+1,nlines=nSim+1,quiet = TRUE),
							nrow=1+nSim,ncol=1+12*nStation,byrow=TRUE)
						StatDf<-monthlyStatDfFun(rfAmtMonthlySD,nSim,nStation,rfStatSelStn,stnNumber,stnName)
					}	
					gridFile<-saveGridFileAs()
					if (gridFile!=""){
						write.table(StatDf, file = gridFile, append = FALSE, quote = TRUE,sep = " ",dec = ".",
						row.names = FALSE,col.names = TRUE, qmethod = "double",fileEncoding = "")
					}
				}
			}
		}
	}
})			
